set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7017748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      '2',
      '1',
      '1',
      '3',
      '2',
      '4',
      NULL,
      NULL,
      '0',
      '1',
      '3',
      '2',
      '2',
      '0',
      '',
      '0',
      '',
      '3',
      '0',
      '2',
      '2',
      '2',
      NULL,
      '',
      '1',
      '0',
      '3',
      '1',
      '2',
      '4',
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      '230',
      NULL,
      NULL,
      63,
      NULL,
      0.965456,
      1,
      1,
      1,
      '321101',
      1,
      ' 3- 6-2000',
      ' 6-19-1999',
      NULL,
      207.038211,
      51,
      18,
      15.286690,
      11,
      90,
      14,
      NULL,
      NULL,
      22,
      2.026732,
      NULL,
      12,
      NULL,
      7.050035,
      26,
      0.268710,
      17.642982,
      NULL,
      33.819945,
      NULL,
      NULL,
      13,
      0.497019,
      88.612495,
      33,
      77.903676,
      60.279139,
      92,
      10.902568,
      ' 7- 8-1999',
      30.511285,
      0.161523,
      13.477553,
      11.205182,
      NULL,
      103,
      ' 8- 0-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      0,
      5.089557,
      ' 3-22-1990',
      0,
      1.667792,
      91.636219,
      0,
      0.799971,
      NULL,
      NULL,
      5.763209,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-1999',
      82,
      72.294643,
      9,
      13.064003,
      61.052959,
      10.822677,
      39.602367,
      NULL,
      47,
      50,
      26,
      NULL,
      ' 9- 7-2003',
      19,
      1.812855,
      14.675121,
      21,
      83.783497,
      122.594569,
      9,
      ' 5-16-1985',
      30,
      5.281532,
      ' 7-20-2002',
      4,
      16.115271,
      18,
      18.381074,
      5,
      9.208895,
      0,
      16,
      1.795824,
      12,
      0.558601,
      1.675396,
      7,
      29.890107,
      3.160377,
      0.447017,
      0.748007,
      0.136848,
      ' 4-28-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      22.206697,
      20.657008,
      ' 9-13-1987',
      NULL,
      NULL,
      NULL,
      38.971570,
      ' 4- 2-2000',
      19.469945,
      ' 1- 3-2000',
      14.685414,
      0,
      ' 5-12-1975',
      74.958624,
      NULL,
      '10-21-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      48.642496,
      7,
      31,
      ' 4-22-1978',
      NULL,
      63,
      '11- 4-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


