set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4222',
      '02043114',
      '00032313',
      NULL,
      '14110323',
      NULL,
      '11113443',
      '43111401',
      '21323142',
      '40120343',
      '23112201',
      '44200441',
      '02101410',
      '20031004',
      '42120440',
      '14040400',
      '32213340',
      '40143201',
      NULL,
      '31023303',
      '13321313',
      '01100230',
      '43414411',
      NULL,
      '03204300',
      '12012221',
      NULL,
      '13300433',
      '02202424',
      NULL,
      NULL,
      '30443343',
      '22101002',
      '20133234',
      '42431104',
      '33123334',
      '33311101',
      '23233400',
      '00033402',
      '42141114',
      '22330442',
      '10342424',
      '43233421',
      '34311201',
      '10134200',
      '042',
      '32',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '221311',
      1,
      ' 8- 2-2001',
      ' 0-21-1980',
      127.096282,
      NULL,
      NULL,
      6.749650,
      47.756928,
      0,
      16.516367,
      4,
      26.042076,
      10.472927,
      39,
      18.297792,
      10,
      20.069144,
      14.218715,
      11,
      16,
      3.222751,
      11.154216,
      8.240897,
      34.837871,
      NULL,
      70.508579,
      2,
      1.381952,
      70,
      NULL,
      39,
      NULL,
      150.977826,
      62,
      ' 5-13-1985',
      NULL,
      NULL,
      13.161102,
      NULL,
      206,
      180,
      ' 8- 6-1977',
      0,
      3.865758,
      0.211323,
      1.317202,
      3,
      0.678759,
      2,
      1.934926,
      0,
      1,
      1.663599,
      NULL,
      1.941882,
      1.536676,
      0,
      NULL,
      0,
      NULL,
      1.493083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-2001',
      72,
      NULL,
      11,
      1,
      13,
      9.550542,
      ' 6-11-1998',
      NULL,
      NULL,
      91.251823,
      NULL,
      0.916867,
      81.746561,
      0,
      0,
      1,
      0.619849,
      3.038709,
      NULL,
      ' 6- 8-1986',
      9,
      NULL,
      65.728395,
      NULL,
      NULL,
      89.445984,
      26,
      37.059767,
      50,
      32,
      79,
      21.420496,
      NULL,
      21,
      22,
      26.969477,
      75.717084,
      4,
      117.627658,
      11.178002,
      NULL,
      NULL,
      23.757981,
      '10-18-1980',
      NULL,
      19.177747,
      1,
      NULL,
      7.949138,
      9.741983,
      0.827773,
      NULL,
      NULL,
      50,
      NULL,
      4.065505,
      NULL,
      11.625109,
      0,
      0,
      0,
      0.293879,
      ' 7-19-1993',
      5,
      1.648638,
      3,
      '10- 0-1997',
      NULL,
      2.886319,
      ' 5-15-1980',
      4,
      NULL,
      NULL,
      42.182688,
      ' 9- 6-1975',
      35,
      '10-29-1983',
      9,
      10,
      ' 4-22-1984',
      28.189734,
      84,
      ' 9-27-1986',
      0,
      4,
      ' 5-27-1989',
      5.436720,
      4.347790,
      ' 8-19-2001',
      2,
      2,
      NULL,
      NULL,
      9.184089,
      43,
      27,
      '10-24-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


