set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8911010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4112',
      '40344420',
      NULL,
      '40334040',
      NULL,
      '32201011',
      '23222214',
      NULL,
      NULL,
      '11334321',
      '03444414',
      '04411303',
      NULL,
      '30232111',
      '04042314',
      '03310104',
      NULL,
      '43320023',
      '32341344',
      NULL,
      '13434233',
      '22141033',
      NULL,
      '34332100',
      '21400104',
      '31043121',
      '01442013',
      NULL,
      NULL,
      NULL,
      '01114114',
      NULL,
      '40104202',
      '10223142',
      '02001323',
      NULL,
      '20412442',
      '24401003',
      '03241122',
      '20442222',
      '01131300',
      '31200010',
      NULL,
      '34031202',
      '03342302',
      '',
      '',
      NULL,
      NULL,
      '1111124',
      0.369065,
      0,
      0,
      NULL,
      '033214',
      0,
      '10- 0-1992',
      ' 1-28-1999',
      89,
      NULL,
      23.695859,
      4,
      2.696888,
      12,
      102.561106,
      14,
      NULL,
      14.465967,
      33.282950,
      3,
      10,
      21.034358,
      23,
      1,
      7.622907,
      9,
      3,
      NULL,
      35.865364,
      5.835442,
      14.282553,
      4.055160,
      NULL,
      33,
      107,
      18.924717,
      NULL,
      148.247343,
      50,
      ' 9-17-1994',
      58,
      47,
      NULL,
      26,
      209.318890,
      151.531213,
      '11-10-1979',
      0.894756,
      3.464920,
      8,
      1.853718,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.574676,
      0,
      1.053496,
      0.038339,
      0.749450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-13-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-22-1985',
      71.050194,
      NULL,
      43,
      19,
      NULL,
      46,
      71,
      NULL,
      NULL,
      37.659187,
      NULL,
      83,
      ' 0-15-1997',
      1,
      14.169315,
      NULL,
      NULL,
      57,
      6,
      7.074316,
      ' 4- 8-1976',
      1,
      11,
      ' 5-17-1994',
      NULL,
      6,
      7.446220,
      9.169010,
      17,
      2.685902,
      NULL,
      19.298759,
      NULL,
      27.816196,
      1,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-15-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      0,
      57.250959,
      ' 4- 9-1981',
      0,
      21.540947,
      19,
      28.596646,
      NULL,
      NULL,
      0.383333,
      107,
      ' 0-24-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.686670,
      NULL,
      NULL,
      71,
      23,
      3,
      49,
      2.601428,
      1,
      NULL,
      1.027743,
      0,
      37,
      0.544720,
      0,
      NULL,
      0.519102,
      1,
      NULL,
      NULL,
      0.349630,
      26,
      NULL,
      17.047194,
      NULL,
      0,
      NULL,
      1,
      0,
      1.008544,
      0.696398,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.963654,
      5.370797,
      0,
      1.973792,
      NULL,
      11.457745,
      0.450232,
      NULL,
      0,
      NULL,
      1,
      0.692751,
      NULL,
      22.698274,
      7,
      20.150130,
      NULL,
      NULL,
      8,
      NULL,
      10,
      0,
      0.523628,
      9.445552,
      1.088945,
      1,
      0,
      0,
      NULL,
      ' 3-14-2001',
      ' 7- 3-1994',
      NULL,
      ' 0-26-1979',
      ' 5-23-1988',
      NULL,
      ' 3-27-1978',
      NULL);
commit;
end;
/


