set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106245';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4011',
      '43404024',
      '13443401',
      '34334433',
      '12034344',
      '01431144',
      NULL,
      '14421411',
      '22344323',
      '12300300',
      '31422301',
      '31004033',
      NULL,
      '00014202',
      NULL,
      NULL,
      '20130002',
      '14040242',
      '33010121',
      '41434021',
      '02442243',
      NULL,
      '23313444',
      '21241022',
      '42312243',
      '01113244',
      '11300211',
      '34222202',
      NULL,
      '11413202',
      '20032312',
      NULL,
      '32342210',
      '34243240',
      '10103100',
      '20101313',
      '00321334',
      '12211433',
      '03340042',
      '33434311',
      '43342413',
      '20241410',
      NULL,
      '44234300',
      '03424320',
      NULL,
      '',
      NULL,
      NULL,
      '3143330',
      3,
      1.745217,
      2,
      NULL,
      '414422',
      NULL,
      ' 7- 1-2001',
      ' 4-25-1999',
      36,
      NULL,
      4.146362,
      NULL,
      11.426495,
      NULL,
      35.187085,
      8.808451,
      7,
      NULL,
      21,
      2,
      NULL,
      14.111633,
      15.780818,
      NULL,
      7.141297,
      NULL,
      NULL,
      NULL,
      64.413132,
      0.169458,
      68.411523,
      11.845373,
      NULL,
      NULL,
      84.616241,
      20,
      14.170699,
      69,
      103.502765,
      '11-17-1978',
      6.749170,
      13.345758,
      NULL,
      NULL,
      33,
      141,
      ' 4-10-1996',
      5.915103,
      NULL,
      4.726233,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      13.521336,
      1.510450,
      1.067925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1975',
      NULL,
      16,
      4,
      NULL,
      8,
      38,
      NULL,
      6,
      47.087019,
      31.693870,
      25,
      27.826686,
      ' 2-27-1990',
      NULL,
      10.192144,
      23.115086,
      35,
      4.203563,
      22,
      8,
      '10- 1-1975',
      NULL,
      9,
      ' 5-14-1994',
      NULL,
      NULL,
      3,
      10.537277,
      11.976059,
      NULL,
      NULL,
      4.607541,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      ' 4-23-1979',
      1.219496,
      78,
      ' 6- 7-1988',
      NULL,
      4,
      5,
      170.907718,
      ' 9-22-1983',
      1.175938,
      1.247679,
      NULL,
      ' 5- 9-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      118,
      NULL,
      29.357217,
      60,
      54,
      36.503921,
      87,
      17,
      8.744847,
      3.235440,
      27.649902,
      1.636498,
      0.142403,
      123.376422,
      NULL,
      NULL,
      NULL,
      0.018428,
      0,
      70.070334,
      0,
      0,
      79.963504,
      45.008186,
      17,
      37.502273,
      0.831206,
      8,
      2,
      0,
      1,
      4,
      4,
      2,
      NULL,
      NULL,
      9,
      13.663969,
      34.403366,
      40,
      NULL,
      0,
      9.344672,
      NULL,
      3.792153,
      1.272034,
      NULL,
      2.611698,
      NULL,
      2.862949,
      45,
      0.585558,
      0,
      15,
      15,
      5,
      9.573071,
      NULL,
      NULL,
      17,
      28.887405,
      6,
      NULL,
      1,
      2,
      6,
      0.040274,
      0.600473,
      0,
      NULL,
      ' 1-17-1985',
      ' 4-26-1988',
      ' 1-22-1976',
      ' 6- 0-2003',
      ' 7-28-1990',
      ' 4- 0-1975',
      '11- 7-1975',
      NULL);
commit;
end;
/


