set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9125703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1232',
      '13421231',
      '13114434',
      '23124000',
      NULL,
      '00100101',
      '44130310',
      '33034244',
      NULL,
      '01320102',
      NULL,
      '22242012',
      '41443123',
      '04404130',
      NULL,
      '12410001',
      '13103131',
      NULL,
      NULL,
      '20442004',
      '43330240',
      '42042100',
      '32433003',
      '01203432',
      '41011420',
      '34133313',
      '44414041',
      '01244211',
      '33332240',
      '00120404',
      '21121423',
      '24041014',
      '00310212',
      '13033324',
      '21203120',
      NULL,
      '41033341',
      NULL,
      '14223003',
      '40133433',
      '31303402',
      '20320112',
      '23230330',
      '21134443',
      '40303231',
      '434',
      '31',
      NULL,
      NULL,
      NULL,
      3.213942,
      1,
      3,
      NULL,
      '310241',
      1,
      ' 3- 2-1991',
      '11-19-1991',
      7,
      NULL,
      3,
      6,
      26,
      NULL,
      70.869410,
      NULL,
      27,
      NULL,
      2,
      NULL,
      NULL,
      2.177997,
      NULL,
      8,
      NULL,
      19.247160,
      NULL,
      11.738822,
      50,
      7.234544,
      NULL,
      15,
      NULL,
      96,
      62,
      53.397219,
      88.533992,
      126,
      81.184182,
      ' 8-22-1975',
      15,
      55,
      23.581680,
      30.478519,
      100.446893,
      173.528802,
      '10- 7-1985',
      0,
      NULL,
      3.074919,
      3,
      3.886424,
      3,
      2,
      1,
      0,
      1,
      0,
      1.587972,
      0.890988,
      0.391092,
      NULL,
      NULL,
      2,
      0.811673,
      0.885003,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-2002',
      69.593213,
      38,
      11.180252,
      4.160471,
      19.090699,
      1,
      ' 6-19-1980',
      0.003147,
      5.878644,
      NULL,
      1,
      0.226193,
      53,
      NULL,
      1.119498,
      NULL,
      1,
      0.475390,
      NULL,
      ' 8-21-2002',
      77.213173,
      68,
      NULL,
      60,
      NULL,
      83,
      50.074657,
      63,
      78,
      85.339048,
      20.706626,
      50,
      ' 4- 4-1980',
      5.084178,
      9,
      NULL,
      NULL,
      60.873990,
      NULL,
      8.322308,
      ' 6- 4-1989',
      22,
      18,
      ' 2-17-2000',
      NULL,
      15,
      0.271567,
      NULL,
      2.492617,
      0.482219,
      NULL,
      2,
      1.009956,
      NULL,
      NULL,
      NULL,
      20.267232,
      21.690021,
      0,
      3,
      2.481034,
      1,
      NULL,
      3.194805,
      5,
      0,
      NULL,
      83.114255,
      6,
      '11- 4-1977',
      17.165654,
      6,
      '11- 6-1983',
      NULL,
      NULL,
      47,
      ' 1-14-1994',
      9,
      9,
      ' 5- 5-1976',
      NULL,
      21,
      ' 4-18-2002',
      8,
      NULL,
      ' 2- 7-1987',
      0.178707,
      2,
      ' 0- 7-1992',
      1,
      2,
      27.895714,
      NULL,
      34.304399,
      33.181271,
      4,
      ' 5-29-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.529704);
commit;
end;
/


