set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      '0',
      NULL,
      '1',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      '1',
      '3',
      NULL,
      '',
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      '1',
      '1',
      '',
      '',
      NULL,
      '1',
      '4',
      '2',
      NULL,
      '3',
      '2',
      '1',
      '0',
      '2',
      '3',
      '404',
      '01013223',
      50.896351,
      0,
      '2122433',
      3,
      0.447090,
      3,
      0,
      '344322',
      1,
      ' 1- 5-1983',
      ' 3-21-1975',
      NULL,
      78,
      5,
      15.416259,
      15.575903,
      NULL,
      37,
      11.788867,
      2.806874,
      NULL,
      2,
      8,
      NULL,
      16.100261,
      9,
      4,
      4,
      16,
      48,
      14,
      11,
      NULL,
      NULL,
      NULL,
      1.674053,
      41.123442,
      47,
      16.814177,
      14.342269,
      139,
      140.394999,
      ' 9- 1-1983',
      43,
      44.542269,
      24.249609,
      20.242794,
      77.197767,
      86,
      ' 9- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      13.190833,
      16.787352,
      16,
      14,
      1.790144,
      ' 5-23-1986',
      3,
      3.497658,
      10.195878,
      NULL,
      3.436630,
      23.702639,
      1.782316,
      1.124211,
      44.126084,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.492968,
      4.710594,
      6,
      39.011606,
      28.047094,
      11,
      NULL,
      NULL,
      9,
      NULL,
      ' 1-11-1981',
      NULL,
      NULL,
      9.529882,
      4.280781,
      NULL,
      7,
      2,
      6,
      NULL,
      35.562449,
      NULL,
      3.130468,
      6.841626,
      11.813683,
      6.374368,
      2.445759,
      6,
      0,
      ' 3-28-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      15.430192,
      0.978751,
      ' 4-12-1994',
      NULL,
      NULL,
      NULL,
      21.812135,
      '11- 9-1974',
      29.385977,
      NULL,
      9.897063,
      9,
      ' 2-25-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.032943,
      268.189486,
      ' 4-19-1988',
      3,
      0.406470,
      0,
      9.134467,
      ' 5-29-1993',
      NULL,
      0,
      220,
      ' 8- 3-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


