set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6403762';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4401',
      NULL,
      '00244403',
      '30002430',
      '03214244',
      NULL,
      NULL,
      '23000040',
      '14222421',
      '14301142',
      '14401002',
      '30211132',
      '23321440',
      '33204334',
      '04202430',
      '01432241',
      '33240111',
      NULL,
      NULL,
      '22432211',
      '41424014',
      '02412430',
      '22431343',
      NULL,
      '23444040',
      '12434023',
      '44233002',
      '10340201',
      NULL,
      NULL,
      '00300003',
      '10402134',
      NULL,
      NULL,
      '30112114',
      '10342143',
      '40444113',
      '33014303',
      '02100310',
      NULL,
      '13012101',
      '34034204',
      NULL,
      '43443130',
      '22012034',
      '',
      '',
      NULL,
      NULL,
      '4223004',
      NULL,
      0,
      NULL,
      NULL,
      '412434',
      3.308511,
      ' 2- 7-1976',
      ' 5- 7-1996',
      5.109870,
      NULL,
      24.680110,
      7,
      24.951523,
      10.355115,
      100,
      19,
      7,
      21,
      32.693774,
      1,
      38.809552,
      12.422341,
      NULL,
      3.224278,
      NULL,
      22.296972,
      NULL,
      NULL,
      NULL,
      11,
      96.016139,
      NULL,
      NULL,
      94,
      205.895785,
      97.653583,
      NULL,
      257.508851,
      64.930309,
      '10- 3-1982',
      9,
      17.385873,
      30,
      25.878170,
      NULL,
      NULL,
      ' 3- 1-1979',
      1,
      1,
      0.524462,
      1.196981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001031,
      1.263256,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1983',
      33,
      NULL,
      99,
      NULL,
      20.025626,
      51.639584,
      NULL,
      84,
      83.416570,
      0,
      3.472061,
      16.668121,
      NULL,
      10.183861,
      18,
      6.379590,
      54,
      50.860265,
      35,
      5.848969,
      '10-13-1980',
      NULL,
      13.248027,
      '11-13-1982',
      2.129771,
      0.303285,
      15.121734,
      2,
      3,
      0.262805,
      NULL,
      9,
      NULL,
      9.872088,
      1.957042,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.577990,
      NULL,
      26.451738,
      ' 3-13-1984',
      1.150773,
      104.848938,
      ' 0-15-1980',
      6,
      0.223750,
      1,
      16.246978,
      NULL,
      28,
      0.733587,
      156,
      ' 7-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      40,
      31.243433,
      NULL,
      19.763129,
      13,
      11.072453,
      NULL,
      0.455771,
      0.365933,
      68,
      1,
      0.697191,
      57,
      NULL,
      0,
      104,
      1.857285,
      2.751418,
      2,
      NULL,
      29,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      38.722619,
      0.190472,
      0,
      1,
      26.129036,
      0,
      NULL,
      1.322277,
      NULL,
      1.446658,
      NULL,
      NULL,
      24,
      8,
      21,
      NULL,
      NULL,
      16.849394,
      NULL,
      1.345305,
      7.601876,
      0,
      3,
      1.842958,
      0.997834,
      1.049103,
      0.544132,
      NULL,
      ' 8-18-1983',
      ' 1- 4-1993',
      ' 2- 1-1989',
      ' 0-27-1977',
      ' 3-26-2003',
      ' 5- 2-1986',
      '10-15-1974',
      NULL);
commit;
end;
/


