set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0121',
      '33323210',
      NULL,
      '10013323',
      '43132004',
      '33430030',
      '03431224',
      '04041224',
      '43043233',
      '10142213',
      '11413303',
      '24303012',
      NULL,
      '44203240',
      '43240344',
      '10323113',
      '24043230',
      '01031023',
      '21044003',
      '20310234',
      '02230410',
      '30321032',
      NULL,
      '13100443',
      '01242034',
      '04321423',
      '10201311',
      '13134222',
      NULL,
      '23101021',
      '40444033',
      '41103122',
      NULL,
      NULL,
      '02400411',
      NULL,
      '13430132',
      '14202403',
      '12411412',
      '23312134',
      '34214243',
      '23321203',
      '42000214',
      '03111100',
      '22204414',
      '313',
      NULL,
      NULL,
      NULL,
      '1441303',
      NULL,
      1.345824,
      NULL,
      NULL,
      '330004',
      NULL,
      ' 7- 5-1987',
      NULL,
      37,
      NULL,
      13.818362,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      20.806760,
      NULL,
      25.278458,
      1.450869,
      37.819484,
      4.539757,
      NULL,
      25.665217,
      31.360788,
      25,
      88,
      6,
      NULL,
      16.116140,
      86.750679,
      0.542464,
      1,
      20,
      15,
      110,
      167.756969,
      30.432101,
      6.125383,
      ' 8-27-1983',
      39,
      22.000666,
      NULL,
      31.160914,
      170,
      60,
      ' 1-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      105.008808,
      NULL,
      NULL,
      8,
      8.852535,
      9,
      ' 4- 6-1984',
      0.281165,
      1,
      195,
      NULL,
      0.385544,
      14,
      0.130183,
      1,
      3,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1987',
      61.813850,
      3.937403,
      79.122104,
      NULL,
      33.938426,
      80.433414,
      49,
      41,
      3,
      9.495152,
      NULL,
      80,
      ' 9-16-1989',
      16,
      NULL,
      NULL,
      55.932155,
      77,
      80.594435,
      6,
      ' 8- 7-1981',
      0.573529,
      24,
      ' 4-15-1978',
      11.037295,
      6,
      8,
      11.200831,
      2.430669,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      0.325179,
      9.435519,
      10.172219,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-26-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      24.986906,
      2.463345,
      '11-24-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 0-1977',
      NULL,
      '10-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      ' 2- 6-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      20.460302,
      ' 1-26-1993',
      16.482414,
      NULL,
      14,
      ' 1-10-1976',
      1,
      61,
      ' 3-18-1987',
      17.559323,
      39,
      17,
      NULL,
      ' 8- 7-2001',
      51.219902,
      1,
      94.702259,
      ' 5-12-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


