set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2014',
      '00303032',
      '44012024',
      '41042131',
      '40140340',
      '34131213',
      '41004420',
      '32201133',
      '04344113',
      '00331321',
      '12203114',
      '30020323',
      '01420103',
      NULL,
      '11332343',
      '21220323',
      NULL,
      '02003423',
      '21114430',
      NULL,
      '02014404',
      '24200113',
      '20410110',
      '22004334',
      '20312401',
      '04242414',
      '12221133',
      '34142144',
      '23220014',
      '22312000',
      '24344120',
      NULL,
      '14212032',
      NULL,
      '40114344',
      NULL,
      '03301240',
      '41322141',
      '43210431',
      '21032110',
      '21014023',
      '10443410',
      '14241244',
      '04411414',
      '43121043',
      '100',
      '42',
      2,
      NULL,
      NULL,
      0,
      16.472064,
      1,
      NULL,
      '001040',
      4.127663,
      ' 7-13-1995',
      ' 1-13-1977',
      55,
      93.554629,
      8.231542,
      26.643202,
      22.635866,
      6,
      94.102734,
      NULL,
      9,
      3,
      36.411734,
      0,
      NULL,
      24,
      16,
      9,
      NULL,
      22.404543,
      77,
      NULL,
      14,
      NULL,
      54,
      18.941289,
      0,
      118.553844,
      181.635325,
      76,
      239.129182,
      227,
      32.232708,
      ' 4-13-1990',
      40,
      47,
      33,
      19.038792,
      NULL,
      217.939431,
      ' 2-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.585242,
      14,
      3,
      2,
      1,
      2.597703,
      ' 5- 5-1993',
      1,
      0.310580,
      183,
      0,
      1.512696,
      115.672355,
      0,
      1.008030,
      17.053600,
      NULL,
      NULL,
      NULL,
      ' 6-13-1987',
      24.396380,
      23.498989,
      NULL,
      NULL,
      28,
      94,
      9.958953,
      48,
      58,
      NULL,
      NULL,
      28.996230,
      ' 7-22-1998',
      22,
      NULL,
      22.953058,
      NULL,
      25.955792,
      24.046130,
      2,
      ' 8-22-1986',
      14,
      6,
      ' 4-22-1975',
      1.020446,
      7.455513,
      13.188316,
      7.655278,
      NULL,
      5.179970,
      0,
      15.815975,
      0,
      30,
      0,
      2.403336,
      10,
      26,
      5.046079,
      0.467363,
      1,
      NULL,
      '11-11-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      53.903027,
      3.696196,
      '10-11-1977',
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      42.668604,
      NULL,
      0.453963,
      14.614022,
      ' 6-18-1997',
      41.498297,
      NULL,
      ' 5-11-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      16,
      ' 8- 0-1977',
      NULL,
      NULL,
      21.388270,
      '11-24-1992',
      2,
      NULL,
      ' 1- 0-1983',
      18.266830,
      27,
      21.197140,
      29,
      ' 6- 7-1993',
      NULL,
      0.222545,
      34.134497,
      ' 0-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


