set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '2',
      '3',
      '0',
      '2',
      '1',
      NULL,
      '4',
      NULL,
      '4',
      '1',
      NULL,
      '2',
      '0',
      '4',
      NULL,
      '0',
      '2',
      '2',
      '2',
      '4',
      '4',
      '4',
      '',
      '4',
      '',
      NULL,
      '1',
      NULL,
      NULL,
      '1',
      '',
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      '3',
      '0',
      '240',
      '00132113',
      42.002574,
      NULL,
      NULL,
      3.295926,
      NULL,
      2,
      NULL,
      NULL,
      2.785792,
      ' 5-29-1977',
      ' 9-11-1994',
      NULL,
      204.415486,
      24,
      NULL,
      13.212621,
      6.815558,
      85.804152,
      17.055674,
      NULL,
      11,
      NULL,
      5,
      NULL,
      NULL,
      41,
      NULL,
      36.334634,
      NULL,
      NULL,
      4,
      NULL,
      6,
      37.697332,
      NULL,
      0,
      5.362058,
      168,
      102,
      8.672010,
      22.229191,
      187,
      NULL,
      47.384006,
      47.500050,
      37,
      NULL,
      3.186822,
      197,
      ' 5- 0-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745099,
      9,
      3.438246,
      11,
      NULL,
      ' 0-21-1999',
      0,
      1.457521,
      42,
      1,
      1.870799,
      91,
      1,
      3.652261,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      89.685174,
      NULL,
      62,
      39,
      83.667146,
      78,
      78.666261,
      NULL,
      89.735645,
      53.903448,
      27.244754,
      ' 2-17-1991',
      1,
      3.965746,
      9.547682,
      32,
      14.257248,
      83,
      8.698720,
      ' 8-22-2001',
      24.954577,
      25,
      '11-26-1988',
      3,
      13,
      5,
      NULL,
      9,
      6.085794,
      0,
      NULL,
      0,
      41.250776,
      1.946138,
      1.354792,
      13.896902,
      8,
      4.991700,
      1,
      1,
      0.704677,
      ' 4- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      138,
      2.589048,
      ' 2- 0-1993',
      NULL,
      NULL,
      NULL,
      55.282475,
      ' 2-10-1974',
      NULL,
      ' 4-28-1995',
      6.051557,
      13.540338,
      ' 8-24-1977',
      NULL,
      NULL,
      ' 1-29-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      ' 3-28-1982',
      31.599283,
      38.649963,
      8.876081,
      NULL,
      0,
      25.677760,
      '11-17-1996',
      NULL,
      3.495900,
      3.985325,
      18,
      ' 2- 6-1980',
      60.138980,
      1.037793,
      NULL,
      ' 9-29-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


