set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7430511';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '3',
      '1',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4',
      '4',
      '0',
      '1',
      NULL,
      '3',
      '2',
      '3',
      '0',
      '0',
      '2',
      '0',
      '3',
      NULL,
      '2',
      NULL,
      '2',
      '',
      '4',
      NULL,
      '2',
      '3',
      '1',
      NULL,
      '',
      '1',
      '1',
      '2',
      '2',
      '4',
      '2',
      '0',
      '0',
      '3',
      '2',
      '2',
      NULL,
      '01134232',
      36.461625,
      44,
      '4200420',
      1.202498,
      181.386927,
      3,
      0,
      NULL,
      4.327458,
      '10-17-1976',
      NULL,
      NULL,
      200.241392,
      1.547967,
      9.697697,
      11,
      6,
      103,
      1,
      12.599894,
      11.779353,
      36.186742,
      5.133338,
      21.822169,
      8.144406,
      NULL,
      10,
      NULL,
      6,
      17.496742,
      21.526992,
      68,
      23,
      16,
      17,
      0.608054,
      81.341811,
      41.428099,
      62.101986,
      NULL,
      75,
      NULL,
      ' 8- 5-1978',
      7.522988,
      14,
      11.227601,
      3.533965,
      210.655665,
      8,
      ' 3-15-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.639275,
      20.320394,
      11.063808,
      NULL,
      29.868328,
      0.589645,
      NULL,
      NULL,
      1.789083,
      113.052895,
      NULL,
      2.236368,
      NULL,
      NULL,
      1.226553,
      55,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1974',
      44,
      68,
      61.058252,
      8,
      53.702220,
      44.508131,
      0.945123,
      NULL,
      31,
      87.490216,
      84.966254,
      NULL,
      ' 2- 8-1990',
      5,
      10,
      14,
      38.514763,
      13.411897,
      36.401885,
      9,
      ' 2-21-1998',
      11.382696,
      20.457820,
      '10-14-1990',
      3,
      1,
      NULL,
      7.407283,
      18.884409,
      2.343147,
      1,
      7.619834,
      1.938074,
      NULL,
      1,
      1.039855,
      15.247460,
      23,
      NULL,
      NULL,
      0,
      NULL,
      ' 6- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      120.369689,
      13.367596,
      ' 9-14-1981',
      NULL,
      NULL,
      NULL,
      17.690810,
      NULL,
      14,
      ' 1- 3-1976',
      6,
      2.706478,
      ' 8- 4-1981',
      21,
      149.619648,
      ' 7- 4-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      13,
      '10-23-1980',
      NULL,
      NULL,
      20,
      NULL,
      0.021087,
      NULL,
      ' 3- 8-1998',
      NULL,
      37,
      8,
      32,
      ' 5-20-1993',
      4.128509,
      1.493887,
      112.184900,
      ' 4-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


