set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34401112',
      '41201213',
      '20043311',
      NULL,
      '03332024',
      '44410314',
      '34021400',
      '10140341',
      '00224332',
      NULL,
      '20114000',
      '10200201',
      NULL,
      '23143214',
      '14443223',
      '10024430',
      '43333132',
      NULL,
      '13421433',
      '24240140',
      '33413201',
      NULL,
      NULL,
      '01243411',
      '11434312',
      '14404343',
      '13340330',
      '14200134',
      '43023333',
      '23411141',
      '34214104',
      '22023403',
      '04012013',
      '14023103',
      '10444131',
      '03242234',
      NULL,
      NULL,
      '43032000',
      NULL,
      '41310241',
      '44444200',
      '14430014',
      '24110203',
      '',
      '',
      NULL,
      NULL,
      '4014342',
      NULL,
      1,
      1,
      NULL,
      '410323',
      NULL,
      ' 5-28-1985',
      '11-16-1986',
      4.881644,
      NULL,
      6.448816,
      21,
      26.449050,
      14,
      NULL,
      0,
      11,
      NULL,
      43.869861,
      6.010535,
      6,
      8,
      18.072392,
      2.936475,
      1.507702,
      2.896913,
      23,
      3,
      49,
      15,
      24,
      NULL,
      NULL,
      64.173987,
      86,
      10,
      68.212408,
      31,
      160.545774,
      ' 7-20-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104385,
      NULL,
      4.466123,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-1987',
      NULL,
      NULL,
      3,
      8,
      9.143132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-28-2003',
      85,
      31.388593,
      29,
      51,
      30,
      34,
      116.137529,
      118.020110,
      59.072416,
      NULL,
      64.205905,
      NULL,
      NULL,
      33,
      4,
      NULL,
      47,
      77,
      164,
      8.557388,
      NULL,
      16,
      31,
      ' 8-12-1984',
      1,
      10.081375,
      9,
      NULL,
      6,
      13,
      NULL,
      9.705522,
      NULL,
      30,
      1.416498,
      3,
      18.122750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69.878345,
      59.899477,
      27.303387,
      ' 1-26-1976',
      NULL,
      104,
      NULL,
      4.466738,
      36,
      7.630755,
      NULL,
      ' 9-24-1988',
      64.482119,
      1,
      73.764316,
      ' 0-27-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      113,
      39.714323,
      72,
      66,
      120,
      18.761324,
      NULL,
      20,
      1.366231,
      12.437714,
      0,
      NULL,
      0,
      43,
      NULL,
      1,
      14.717508,
      1.666648,
      1,
      78.113361,
      12.697726,
      1,
      122.431795,
      63.673804,
      29.664611,
      NULL,
      0,
      83.249973,
      0.272716,
      2,
      NULL,
      NULL,
      1.560650,
      NULL,
      79.674882,
      6,
      23.682845,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484471,
      10.135010,
      1.333767,
      3.530484,
      NULL,
      NULL,
      0.031120,
      38.044111,
      2.980091,
      NULL,
      1.536450,
      3,
      15.048519,
      8,
      22.501561,
      33.582937,
      NULL,
      NULL,
      18,
      12,
      1,
      1,
      NULL,
      NULL,
      1.681889,
      1.747288,
      1.921343,
      1.279323,
      12,
      ' 8- 4-2000',
      ' 5- 2-1976',
      '10- 9-2002',
      ' 2-14-2002',
      ' 8-14-1978',
      NULL,
      '10-19-1980',
      NULL);
commit;
end;
/


