set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1044',
      '10122000',
      '33113113',
      '31303223',
      '20432410',
      '23334323',
      '03222304',
      '01334002',
      '20404133',
      NULL,
      '01431003',
      '34243233',
      '12111044',
      NULL,
      '42432234',
      '41302104',
      '12322240',
      '40100224',
      NULL,
      '03000322',
      '03413222',
      '20410232',
      NULL,
      '43212233',
      NULL,
      NULL,
      '10001432',
      '20303441',
      '33413442',
      '04304113',
      '04204100',
      '14013123',
      '22222140',
      '11412430',
      '34021333',
      '03414301',
      '33240110',
      '22223222',
      '42104034',
      NULL,
      '44131431',
      NULL,
      '21010041',
      '33042441',
      '30442322',
      NULL,
      '01',
      NULL,
      NULL,
      NULL,
      2.052832,
      25.919022,
      3,
      NULL,
      NULL,
      1.721565,
      ' 7-24-1988',
      '11-24-1992',
      NULL,
      NULL,
      17.452240,
      7.932414,
      NULL,
      5.445231,
      61.908403,
      20,
      25,
      17,
      27.469873,
      3.378503,
      18,
      2.646018,
      NULL,
      9.414587,
      20,
      31,
      NULL,
      3.210821,
      NULL,
      5,
      NULL,
      14.761212,
      0,
      NULL,
      41,
      16,
      22.843700,
      NULL,
      33.777058,
      ' 0-19-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505308,
      0.204406,
      1.563258,
      1.801143,
      1.224550,
      NULL,
      1,
      1,
      0.484445,
      NULL,
      1,
      0,
      1.260890,
      0,
      1,
      NULL,
      0,
      NULL,
      0.422371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.279717,
      26.510819,
      11,
      NULL,
      2.032090,
      5.318118,
      ' 0-25-1985',
      3,
      1,
      84,
      1,
      0.922463,
      NULL,
      0.037019,
      NULL,
      18,
      0.803843,
      1,
      177,
      ' 1-28-1991',
      1.914796,
      39,
      NULL,
      61.463914,
      54,
      NULL,
      72,
      NULL,
      78.949806,
      4.108297,
      41,
      83,
      ' 9-24-1981',
      NULL,
      26,
      13,
      14.323872,
      NULL,
      149.040511,
      9,
      ' 3- 8-1976',
      26.788433,
      24,
      NULL,
      7,
      NULL,
      16,
      NULL,
      16,
      5,
      NULL,
      0.012391,
      NULL,
      103,
      1,
      23.700151,
      23,
      21.858043,
      1.007361,
      1.300164,
      1.972433,
      1,
      '10- 2-1987',
      3.532170,
      2.073737,
      1,
      ' 8-18-1997',
      37.408439,
      8.189786,
      ' 7-11-2001',
      NULL,
      NULL,
      NULL,
      15.577904,
      ' 9-12-1998',
      NULL,
      ' 9-18-1988',
      1.768357,
      5,
      ' 1-17-1978',
      112,
      112.917006,
      ' 6- 3-2002',
      7,
      1,
      ' 2-12-1987',
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      ' 7-23-2001',
      29.499518,
      25,
      14,
      ' 7- 8-2001',
      0,
      5.438785,
      NULL,
      5,
      20.478404,
      1.972409,
      NULL,
      ' 3- 2-1997',
      23,
      NULL,
      139,
      '10-20-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11);
commit;
end;
/


