set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9697949';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3000',
      '40340004',
      '40342431',
      '20223034',
      '24043330',
      '34302224',
      NULL,
      '01102424',
      '31132131',
      NULL,
      '03402211',
      '14303144',
      '42001304',
      '22034031',
      NULL,
      '41310101',
      '21013442',
      '42333243',
      NULL,
      NULL,
      '21430020',
      NULL,
      '30320421',
      NULL,
      '43100331',
      '43034302',
      '14344201',
      NULL,
      '31014333',
      '31000413',
      '42203042',
      '03104134',
      '14011040',
      '00212111',
      NULL,
      '11233224',
      '02232031',
      '40013000',
      '24013404',
      '10122212',
      '04121011',
      '20440033',
      NULL,
      NULL,
      '03111234',
      NULL,
      '04',
      38,
      20.596718,
      '1022342',
      0,
      NULL,
      0,
      NULL,
      '123042',
      3.242690,
      ' 2-21-2003',
      ' 1- 4-1987',
      NULL,
      76,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      11.414141,
      12.351181,
      15.313703,
      30.986186,
      13,
      12.160324,
      17.219209,
      23,
      13.624395,
      19.803897,
      18.142780,
      NULL,
      12.290188,
      NULL,
      NULL,
      15.490061,
      0,
      NULL,
      NULL,
      17,
      103.118619,
      56,
      5,
      126.481246,
      '11- 4-1988',
      NULL,
      4,
      22.169993,
      9.040307,
      2,
      35.952789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.971742,
      9.820271,
      31.944893,
      NULL,
      34,
      NULL,
      ' 7- 5-1994',
      1,
      NULL,
      135,
      0.812548,
      1,
      36,
      1,
      0,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      69,
      89.150926,
      NULL,
      121.329605,
      2,
      18,
      96,
      76,
      25,
      84.717258,
      86,
      ' 0-12-1976',
      13.660813,
      3,
      12.709787,
      NULL,
      15,
      27,
      NULL,
      ' 5-18-1982',
      9,
      3.727366,
      ' 7- 4-1980',
      5,
      2.321778,
      8.408580,
      9.207467,
      16,
      5,
      0,
      1,
      1,
      NULL,
      3,
      0.262099,
      9.456590,
      27,
      2.564094,
      NULL,
      8.944533,
      5.121050,
      ' 7-13-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      153.732194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-14-2000',
      24,
      ' 6-14-1978',
      12,
      4.729325,
      ' 3-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      10.707488,
      ' 4-27-1975',
      NULL,
      27.856054,
      13,
      NULL,
      0,
      109.014281,
      ' 2- 9-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


