set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02434043',
      '13020430',
      NULL,
      '10311401',
      '03012440',
      '03444442',
      '23042204',
      '14410231',
      '13423232',
      NULL,
      '12333102',
      NULL,
      '23334341',
      '31241232',
      NULL,
      NULL,
      '21313030',
      '34313034',
      '04023202',
      NULL,
      '22200444',
      '34130343',
      '22310213',
      NULL,
      '43303204',
      '04331230',
      '42004223',
      '01210304',
      '01301004',
      '34340023',
      '02024440',
      '31202224',
      '42341134',
      '20032320',
      '04213033',
      '10023434',
      '32002444',
      '24110200',
      '13132233',
      NULL,
      '11222444',
      NULL,
      '04223341',
      '42432404',
      '',
      '',
      NULL,
      NULL,
      '3040001',
      NULL,
      NULL,
      1,
      NULL,
      '020142',
      2,
      ' 0-26-2003',
      ' 6-27-1988',
      NULL,
      NULL,
      32,
      7,
      45.269913,
      27.908147,
      NULL,
      6.429323,
      2,
      NULL,
      19,
      0,
      36.652009,
      NULL,
      23.499089,
      6.127575,
      NULL,
      19.037258,
      6.313244,
      NULL,
      31.757324,
      1,
      45.652681,
      2,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      117.588245,
      183,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      0,
      111.146452,
      ' 1-21-1989',
      6,
      2,
      0.247664,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892824,
      1,
      NULL,
      1.086257,
      NULL,
      0.960812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 1-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-21-1984',
      48,
      95,
      49,
      53.070095,
      32.561735,
      NULL,
      31,
      NULL,
      69,
      2.596981,
      NULL,
      36,
      ' 8-29-1990',
      17,
      7.697976,
      0,
      0.298179,
      47.936449,
      0.892345,
      2.766362,
      NULL,
      NULL,
      6,
      ' 5-19-2000',
      3,
      NULL,
      9,
      5.303192,
      1,
      NULL,
      NULL,
      3,
      NULL,
      51.558711,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      ' 1-14-1979',
      2,
      103,
      NULL,
      10.882137,
      NULL,
      8,
      40,
      ' 4-28-1999',
      46,
      0,
      NULL,
      ' 2-28-1992',
      NULL,
      NULL,
      NULL,
      17.092801,
      58.292764,
      130,
      NULL,
      NULL,
      88,
      22.797510,
      8,
      NULL,
      5,
      5.759267,
      32,
      0.106405,
      1,
      92,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      143,
      0.346031,
      0,
      65.610196,
      5.737931,
      21,
      67,
      0,
      18,
      0.989799,
      NULL,
      1,
      1,
      0,
      0.639621,
      NULL,
      85,
      NULL,
      7,
      1.916071,
      42,
      0.713239,
      NULL,
      NULL,
      0.872215,
      NULL,
      1.847688,
      NULL,
      NULL,
      23.721750,
      3.666398,
      92,
      1.903586,
      1.226312,
      11.086043,
      NULL,
      NULL,
      24.649911,
      NULL,
      26.906262,
      15,
      0,
      5.655076,
      11.238903,
      6.946099,
      3.364483,
      0.953744,
      NULL,
      NULL,
      2.823477,
      13.164633,
      ' 0- 6-1982',
      '10-11-1979',
      NULL,
      '11-25-1977',
      ' 3-18-2001',
      NULL,
      ' 1-17-1979',
      NULL);
commit;
end;
/


