set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1040',
      '13113034',
      NULL,
      '01400141',
      '40412233',
      '13012120',
      '42330224',
      '20133020',
      '41020103',
      NULL,
      '21423444',
      '34011324',
      '22411311',
      '21133144',
      NULL,
      NULL,
      '00241024',
      '20431000',
      '24341020',
      '13242241',
      NULL,
      '34342122',
      NULL,
      NULL,
      '12122143',
      '22040431',
      '00032330',
      '23301443',
      '33034034',
      NULL,
      '44120240',
      NULL,
      '42003412',
      '34210314',
      '41130023',
      NULL,
      '02304232',
      '21422304',
      '20122042',
      NULL,
      '21031443',
      '20343313',
      NULL,
      '04232344',
      NULL,
      '204',
      '21',
      NULL,
      NULL,
      '3024221',
      2.137614,
      20.478529,
      1,
      NULL,
      '212034',
      2,
      ' 4-12-2000',
      NULL,
      38,
      NULL,
      7.325765,
      14.434458,
      NULL,
      3,
      NULL,
      NULL,
      10.565545,
      4,
      NULL,
      14,
      NULL,
      24,
      18,
      10.455152,
      11.518715,
      NULL,
      56,
      23,
      22,
      NULL,
      48.375068,
      5.530775,
      1,
      NULL,
      165.704469,
      NULL,
      67.518464,
      158.642324,
      113.296234,
      ' 4- 1-1991',
      18,
      NULL,
      NULL,
      22.735036,
      NULL,
      56.885807,
      ' 4-22-1982',
      4.319213,
      1.451855,
      0.621066,
      0,
      2,
      0,
      6,
      NULL,
      1,
      1,
      3,
      0.265415,
      1.539916,
      0.253069,
      0,
      0,
      0,
      0.689175,
      1,
      0.155742,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1988',
      74,
      13.326297,
      5.662033,
      1,
      7.938729,
      11.811086,
      ' 8-13-1980',
      NULL,
      0.373202,
      82,
      0,
      0.618506,
      68.678692,
      1.360939,
      0.794784,
      8.234048,
      1,
      0,
      NULL,
      ' 6- 9-1993',
      40.935048,
      4,
      42,
      NULL,
      97,
      25,
      39,
      47.743517,
      13.619523,
      39,
      30,
      83.536614,
      ' 4- 8-2003',
      8,
      17.673538,
      2,
      21,
      NULL,
      14,
      1,
      ' 5- 5-1980',
      16.541292,
      4.118404,
      NULL,
      1,
      NULL,
      12,
      6.057788,
      6,
      0.748670,
      1,
      NULL,
      0,
      3,
      NULL,
      1.486360,
      0.970185,
      13.741259,
      8,
      7,
      NULL,
      3.503438,
      ' 8-29-1977',
      3,
      1.285513,
      NULL,
      ' 4-29-1976',
      36.622721,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      ' 2-23-1985',
      35,
      ' 4-24-1991',
      0,
      11,
      NULL,
      79,
      7,
      ' 4- 0-1989',
      9.391871,
      18,
      ' 2-13-1976',
      3.061133,
      11.748748,
      '11-29-1985',
      1,
      1,
      NULL,
      ' 7- 4-1997',
      1.352336,
      NULL,
      2.629133,
      ' 9-25-2002',
      1,
      316.883860,
      '11-17-2002',
      5,
      23.568115,
      NULL,
      115,
      '10- 2-1995',
      38.411121,
      NULL,
      374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.728109);
commit;
end;
/


