set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1030',
      '43213213',
      '04142313',
      '04014422',
      '33433401',
      '14031120',
      '04023103',
      NULL,
      '00242221',
      '14422442',
      '30123303',
      '11222231',
      '13011114',
      '22414404',
      '01044133',
      '44332021',
      '21313202',
      '33042044',
      '32013021',
      NULL,
      '02301400',
      '11211002',
      NULL,
      '00103424',
      '20311201',
      '32132321',
      '10322200',
      '00444032',
      NULL,
      '44444234',
      '43242310',
      '33101100',
      '31341414',
      '43004334',
      '32231222',
      '11303304',
      '01112321',
      '43233011',
      '04212432',
      NULL,
      '23111410',
      '04413440',
      '20113014',
      '41222422',
      '12414142',
      '420',
      '41',
      NULL,
      NULL,
      '3210144',
      0,
      104,
      1,
      NULL,
      '140100',
      0.220288,
      NULL,
      ' 8-13-1991',
      36.301845,
      NULL,
      NULL,
      9.424378,
      1.418986,
      10,
      1.000978,
      1,
      6.516193,
      2.701788,
      6.784508,
      2,
      25.829725,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      50.709181,
      4.189646,
      6,
      8.099012,
      28,
      8,
      0.143315,
      15.024573,
      74,
      57.788198,
      71.808633,
      97,
      70,
      ' 9- 4-1999',
      32.612611,
      NULL,
      12.043415,
      NULL,
      66,
      86,
      ' 7-24-1986',
      1.729132,
      0.769652,
      0.305444,
      1.049737,
      1,
      NULL,
      6,
      9,
      1.190054,
      0.537209,
      0,
      0,
      1,
      1,
      NULL,
      1.795191,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1980',
      34,
      16,
      9.346802,
      14,
      14,
      NULL,
      ' 6- 9-1977',
      1.920406,
      0,
      156,
      1,
      NULL,
      86.492270,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      46.389199,
      73,
      27.689311,
      11.676597,
      34.639273,
      NULL,
      84,
      75,
      65.949491,
      NULL,
      18.226464,
      4.994935,
      ' 5-19-1975',
      1.294155,
      5.228929,
      2.023585,
      8,
      NULL,
      NULL,
      2.668323,
      NULL,
      NULL,
      0,
      '11-16-1993',
      4,
      6,
      NULL,
      2,
      7,
      0,
      NULL,
      NULL,
      3.735550,
      20,
      5,
      2.110215,
      1.083640,
      NULL,
      12.001404,
      1.895180,
      0,
      2.577766,
      ' 1-16-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127353,
      ' 7-21-2000',
      36,
      ' 6-27-1975',
      12.808691,
      2.216979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583669,
      ' 7-22-1993',
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      ' 6-12-1981',
      20,
      NULL,
      16,
      ' 8-10-1984',
      0,
      268.638436,
      ' 3- 5-1974',
      3,
      4.264749,
      10.739509,
      78.925867,
      NULL,
      68.171869,
      NULL,
      284.586958,
      ' 2-22-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


