set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '1',
      '2',
      '1',
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      '0',
      '4',
      '1',
      '3',
      NULL,
      '1',
      '4',
      '1',
      '1',
      '2',
      NULL,
      '2',
      '1',
      '4',
      '',
      '3',
      '',
      '1',
      '1',
      '4',
      '2',
      '2',
      '',
      '',
      NULL,
      '1',
      NULL,
      NULL,
      '4',
      '0',
      '3',
      '2',
      '1',
      '4',
      '1',
      '441',
      '21',
      56,
      15,
      '0411312',
      0,
      54,
      3,
      NULL,
      '410144',
      2.768614,
      ' 5-15-1999',
      ' 1- 0-1999',
      21.641193,
      NULL,
      1.967882,
      7.988460,
      2.928748,
      15,
      53.116836,
      3.464352,
      NULL,
      8,
      14,
      4,
      NULL,
      9,
      20.800978,
      NULL,
      21.282987,
      11.933767,
      31.885056,
      3.959614,
      15.091128,
      10,
      2.040944,
      4,
      1.277336,
      NULL,
      117.867706,
      40,
      139,
      129.164445,
      NULL,
      ' 1- 0-1995',
      21.112046,
      NULL,
      27,
      4.820132,
      110,
      96,
      ' 0-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      NULL,
      44.301345,
      26.369499,
      3.070984,
      ' 3- 3-1988',
      0.201538,
      1,
      NULL,
      0,
      1,
      96.599832,
      1,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      ' 5-15-2002',
      NULL,
      24,
      43.916756,
      21.161541,
      57.439658,
      46.891629,
      47,
      23,
      21,
      24.015397,
      NULL,
      10.940697,
      NULL,
      3,
      9,
      5.769042,
      NULL,
      18.524947,
      2,
      3,
      '10- 5-2002',
      5,
      1.467195,
      ' 8-24-1998',
      0.150885,
      0.042569,
      6,
      3,
      5,
      3.352662,
      1,
      5,
      1.653906,
      14.671978,
      1,
      1.137626,
      5.943193,
      10,
      6,
      NULL,
      NULL,
      1.892427,
      ' 2-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537803,
      ' 1- 9-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-1994',
      33,
      ' 8- 4-1999',
      8,
      8,
      ' 9-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12.569669,
      NULL,
      35.904293,
      15.369526,
      7,
      ' 1-18-2000',
      1.652421,
      152.204812,
      ' 2-19-1999',
      2,
      79,
      NULL,
      123.210024,
      ' 4-17-1977',
      13.792607,
      NULL,
      72.712458,
      ' 8-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


