set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      '2',
      '0',
      '1',
      '1',
      '4',
      '1',
      '3',
      '0',
      '1',
      '4',
      '0',
      '3',
      '3',
      '2',
      '0',
      '1',
      '3',
      '4',
      NULL,
      NULL,
      '2',
      '',
      NULL,
      '',
      NULL,
      '1',
      '0',
      NULL,
      '2',
      '',
      NULL,
      '0',
      '3',
      '4',
      '1',
      '4',
      '4',
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      '221',
      '24013114',
      55.101951,
      22,
      '1021412',
      0.326617,
      263.323269,
      0,
      1,
      NULL,
      3,
      ' 0- 5-1974',
      ' 8-27-2003',
      30,
      78.255911,
      30,
      3,
      NULL,
      1,
      1,
      NULL,
      4.077873,
      10.814334,
      8.117892,
      7,
      8,
      NULL,
      2.255288,
      0.406200,
      12,
      12,
      26,
      7.685095,
      30,
      NULL,
      17,
      1,
      1.462287,
      12,
      115.300190,
      72.318982,
      4.116226,
      90,
      157,
      '11-22-1980',
      19,
      NULL,
      19.343677,
      15,
      81,
      NULL,
      ' 3- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.945626,
      54.879490,
      58.714940,
      NULL,
      55.287325,
      0,
      ' 3- 0-1996',
      0,
      1.870651,
      NULL,
      NULL,
      0,
      51,
      1.351746,
      0.928075,
      2.144588,
      NULL,
      NULL,
      NULL,
      ' 9- 1-1984',
      NULL,
      103.297396,
      13.655874,
      103,
      85.077186,
      31,
      38.813871,
      NULL,
      27,
      103.278632,
      62,
      NULL,
      ' 7-22-1997',
      2,
      9.709154,
      3.397768,
      21.967401,
      NULL,
      NULL,
      0.749800,
      ' 1-29-2001',
      12.755128,
      9.508681,
      ' 4-11-1997',
      0.204170,
      2,
      0,
      8,
      11,
      NULL,
      0.547047,
      2.449111,
      0.346810,
      33.053981,
      1.698596,
      1,
      1.536185,
      1,
      NULL,
      2.231209,
      1,
      0,
      '11-21-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      ' 1-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1981',
      NULL,
      ' 9-13-1984',
      5,
      5.089568,
      ' 0- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      ' 1-18-1977',
      34.890278,
      6.792061,
      27,
      '10-27-2001',
      1,
      340.172013,
      ' 4- 1-1990',
      NULL,
      NULL,
      13.160356,
      102.213760,
      ' 5- 3-2000',
      62.273849,
      NULL,
      369.990338,
      ' 0-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


