set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '4',
      NULL,
      '0',
      '0',
      NULL,
      '0',
      NULL,
      '1',
      '1',
      '2',
      NULL,
      '0',
      '3',
      '4',
      NULL,
      '4',
      '3',
      '2',
      '3',
      '3',
      '3',
      '4',
      '',
      '3',
      NULL,
      '1',
      '0',
      '3',
      '4',
      '1',
      '',
      '',
      '2',
      '3',
      '1',
      '3',
      '1',
      NULL,
      NULL,
      '0',
      '4',
      '2',
      '1',
      '321',
      '14331424',
      22,
      47.658469,
      '0443433',
      3,
      NULL,
      NULL,
      NULL,
      '240012',
      3,
      ' 0- 4-1981',
      ' 1- 1-1993',
      27.482693,
      NULL,
      35,
      14,
      NULL,
      19.414464,
      NULL,
      10.814232,
      9,
      0.671733,
      11.224204,
      11.658023,
      24.232700,
      14,
      27.361248,
      6.209310,
      17,
      8.147473,
      7,
      6,
      19.824917,
      12,
      NULL,
      5.810889,
      NULL,
      35.934193,
      102,
      35.429907,
      53.026496,
      37,
      87,
      ' 8- 4-2003',
      21.776153,
      10,
      30,
      9,
      NULL,
      73,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.017613,
      NULL,
      3.689562,
      0,
      0.015208,
      ' 2-18-1993',
      1.372138,
      0.968620,
      NULL,
      1,
      0.815329,
      110.806401,
      1.380124,
      0.577549,
      14.300772,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1975',
      70.477154,
      65.200267,
      NULL,
      9,
      68,
      NULL,
      69,
      50.554001,
      42,
      NULL,
      8.351985,
      21.749878,
      ' 0- 2-1977',
      10.316617,
      7,
      7.011129,
      NULL,
      31.112849,
      2,
      4.934776,
      ' 2-27-1978',
      NULL,
      2,
      ' 9-24-1998',
      NULL,
      9.161263,
      9.850607,
      3.011673,
      4,
      7.043336,
      0,
      9.619327,
      1.692274,
      31,
      1,
      NULL,
      0.245769,
      10,
      NULL,
      7.648813,
      1,
      0.156854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616330,
      ' 3-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1998',
      NULL,
      '11-19-1994',
      8.565997,
      6,
      ' 2-29-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      9.398553,
      ' 7- 7-1984',
      55.808824,
      14.333858,
      11.170159,
      NULL,
      1.311451,
      207,
      ' 3-16-1990',
      15,
      90.374216,
      9.292607,
      NULL,
      NULL,
      NULL,
      1,
      97,
      ' 9- 0-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


