set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31232220',
      NULL,
      '33212432',
      '01042323',
      '20040433',
      '31440234',
      '24012120',
      NULL,
      '44440420',
      '31033423',
      '04144442',
      '21221431',
      NULL,
      NULL,
      '10311142',
      NULL,
      '44123404',
      NULL,
      '33240001',
      NULL,
      NULL,
      '42010212',
      '42413332',
      '02421422',
      '12202220',
      '44120140',
      '31130122',
      NULL,
      '41210011',
      '01304014',
      '21320134',
      '12320140',
      '14340300',
      NULL,
      '24421233',
      NULL,
      '11121033',
      NULL,
      '04204443',
      '03423123',
      '32222033',
      NULL,
      '32131423',
      '10404404',
      '211',
      '44',
      NULL,
      NULL,
      '1041233',
      NULL,
      NULL,
      1,
      NULL,
      '114122',
      0,
      ' 3-11-2000',
      ' 4-16-1989',
      61,
      NULL,
      14,
      12,
      1,
      16.505751,
      21.258803,
      0,
      3,
      1.720075,
      NULL,
      NULL,
      NULL,
      NULL,
      5.415282,
      7,
      5.703903,
      9.483407,
      NULL,
      1,
      3.808162,
      6,
      0.687723,
      NULL,
      0,
      2.027858,
      49,
      45,
      NULL,
      52.051665,
      NULL,
      ' 6-24-1984',
      3.352185,
      9.318175,
      20,
      NULL,
      104,
      111,
      ' 9- 8-1981',
      1.276026,
      2.872446,
      3.537552,
      9.817869,
      9.760942,
      2,
      2,
      4,
      1.935281,
      0,
      2.052828,
      2,
      1.428073,
      NULL,
      1.623874,
      1.235292,
      0,
      1.871368,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1985',
      29,
      NULL,
      13,
      NULL,
      5,
      0,
      NULL,
      1,
      1.659651,
      65.470913,
      1,
      0,
      NULL,
      0,
      NULL,
      33,
      0.993258,
      1.020798,
      203.393000,
      ' 3-11-1981',
      86,
      NULL,
      63.538596,
      102,
      1.207591,
      73.236237,
      67.501103,
      100.377808,
      34,
      NULL,
      57,
      53.644600,
      '10- 2-1974',
      0,
      NULL,
      0.403992,
      14,
      NULL,
      3.599726,
      NULL,
      NULL,
      0.982172,
      1.367070,
      ' 7-20-1996',
      5.994658,
      9,
      NULL,
      10,
      1.499897,
      1,
      1.027592,
      7,
      NULL,
      33,
      1,
      1.607234,
      6,
      NULL,
      10.504254,
      NULL,
      1,
      NULL,
      ' 8-21-1980',
      1,
      0.023875,
      0,
      ' 3-19-1980',
      9,
      20.360612,
      NULL,
      NULL,
      NULL,
      NULL,
      35.979750,
      NULL,
      50.238038,
      ' 3-13-2003',
      NULL,
      15,
      ' 4- 1-1998',
      59,
      4,
      NULL,
      10,
      1.464085,
      '10-20-1985',
      1,
      1.436577,
      NULL,
      0,
      2,
      3.879387,
      ' 7-18-1991',
      24.993401,
      27,
      NULL,
      NULL,
      11.929436,
      543,
      ' 0-20-2000',
      11.919543,
      55.463096,
      NULL,
      16.090104,
      ' 0-11-1983',
      32.155107,
      0.965633,
      210,
      '11- 1-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4);
commit;
end;
/


