set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3412',
      '20422041',
      '30310200',
      '02302024',
      '03214114',
      '32303141',
      '02001240',
      '34104130',
      '03343123',
      '41110130',
      '11421110',
      NULL,
      '02200044',
      '13140323',
      '13042332',
      '43200030',
      '30244023',
      '43300020',
      '30001001',
      '04404220',
      '31413220',
      '31142034',
      '14211141',
      '11310404',
      '00332043',
      '43013401',
      '24124003',
      '42041420',
      '31131302',
      '31421320',
      '43432003',
      NULL,
      '24011400',
      '42410324',
      '31413032',
      '30201112',
      NULL,
      '31312320',
      NULL,
      '12344321',
      '22230343',
      '03121423',
      '30344133',
      '14441013',
      '00010043',
      NULL,
      '41',
      NULL,
      NULL,
      '0000123',
      3.332258,
      7.879433,
      NULL,
      NULL,
      '422421',
      NULL,
      ' 8- 7-1982',
      ' 1-10-2001',
      52.826927,
      NULL,
      5,
      12.554507,
      2.920473,
      6.792226,
      26.370477,
      1,
      8.021528,
      0.398094,
      NULL,
      7.356378,
      18.573858,
      6,
      NULL,
      7.605837,
      0.613464,
      9.596820,
      33.368763,
      13.957734,
      16,
      6.370534,
      55,
      0.187265,
      1.737761,
      NULL,
      30,
      10,
      62,
      70.755408,
      18,
      ' 5-19-2002',
      NULL,
      17.874963,
      1.215751,
      NULL,
      133.933618,
      88,
      ' 9-12-1988',
      NULL,
      0,
      5.353492,
      3.232276,
      3,
      0.170613,
      10.232503,
      1,
      0,
      1.259027,
      1,
      1.510913,
      NULL,
      2.166167,
      1,
      0.185386,
      1.550023,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-1974',
      43,
      NULL,
      13.907720,
      8.779037,
      8,
      NULL,
      ' 0-28-1990',
      1,
      1,
      11,
      0,
      NULL,
      33.594223,
      0.272709,
      0.654793,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-12-1980',
      62,
      38.364930,
      6.643430,
      13.507296,
      61.885864,
      NULL,
      97.319479,
      0.917804,
      NULL,
      90.700205,
      NULL,
      33,
      '10-25-2000',
      6,
      1,
      11,
      23,
      25,
      0,
      0.511547,
      '11-18-1997',
      0,
      0.552475,
      ' 4-22-1976',
      4,
      9.511175,
      1.292799,
      4.792314,
      NULL,
      NULL,
      1.812251,
      2.858703,
      0,
      3,
      0,
      1.869231,
      5,
      12.948097,
      14,
      5.395679,
      1.089206,
      0,
      ' 6-12-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.465724,
      '11- 6-2000',
      NULL,
      NULL,
      NULL,
      30,
      ' 1-25-1995',
      NULL,
      '10-21-1975',
      8,
      3.093389,
      '10- 7-1982',
      82,
      NULL,
      ' 9- 0-1995',
      11,
      NULL,
      ' 9-28-1996',
      NULL,
      NULL,
      NULL,
      1,
      1,
      6.173677,
      '11- 6-2000',
      8.748832,
      8.556099,
      21,
      ' 1- 4-1983',
      2,
      118,
      NULL,
      NULL,
      NULL,
      6.498641,
      17,
      ' 7-13-1990',
      NULL,
      1,
      94,
      '10- 8-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


