set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4011',
      '44030301',
      NULL,
      '11423340',
      NULL,
      '34330321',
      NULL,
      '10312310',
      '31013233',
      '04000030',
      '31312124',
      '20344043',
      '11042102',
      '00114432',
      NULL,
      '44132012',
      '42044003',
      '01301134',
      '30224331',
      '30122031',
      NULL,
      NULL,
      '02343114',
      NULL,
      NULL,
      '23221322',
      '03020104',
      '23414122',
      '40110401',
      NULL,
      '33203324',
      '34341143',
      '14013230',
      '02214232',
      '32442143',
      '42143003',
      '31012322',
      '13143331',
      '00324200',
      '20442203',
      '34100133',
      '22143013',
      '34312030',
      '04114420',
      NULL,
      '013',
      '20',
      17.962162,
      3,
      '1230314',
      0.140759,
      NULL,
      0,
      NULL,
      '020011',
      0.665460,
      NULL,
      NULL,
      22,
      118.837411,
      20.310561,
      12.541510,
      6,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.417417,
      NULL,
      10.016883,
      NULL,
      3.227947,
      2,
      1,
      5,
      17.172669,
      9.376245,
      NULL,
      10.133643,
      29,
      4,
      0,
      52,
      NULL,
      NULL,
      5,
      17,
      73,
      '11-28-1988',
      10,
      27.693020,
      NULL,
      NULL,
      NULL,
      108.078375,
      ' 9-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      38,
      NULL,
      16.137738,
      11,
      NULL,
      ' 1- 8-1990',
      1.982868,
      1,
      NULL,
      3,
      NULL,
      33,
      NULL,
      1.212232,
      12,
      NULL,
      NULL,
      NULL,
      '11-18-1984',
      64,
      129,
      36,
      20.074807,
      126.818634,
      70.917172,
      103,
      61,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      9,
      9,
      18,
      NULL,
      3,
      ' 0-24-1989',
      5.357041,
      3.100869,
      ' 3-28-1983',
      9.102316,
      NULL,
      NULL,
      6.277981,
      11.405658,
      NULL,
      1.277710,
      11.044193,
      0,
      1.514268,
      1,
      2.645430,
      5,
      14,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75.096910,
      2.200016,
      ' 8- 3-1981',
      NULL,
      NULL,
      NULL,
      14.896889,
      ' 7-19-1979',
      4,
      ' 0-17-1981',
      3.603043,
      7,
      ' 3- 0-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      7,
      NULL,
      55.839198,
      11.502532,
      NULL,
      '10- 3-1987',
      2.781611,
      265.622081,
      ' 6-28-1987',
      NULL,
      NULL,
      5,
      NULL,
      ' 5-25-1978',
      22.443784,
      1,
      NULL,
      '10-14-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


