set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '4',
      '1',
      '0',
      '2',
      '2',
      '3',
      '0',
      '0',
      '1',
      '4',
      '4',
      '2',
      '4',
      '0',
      '0',
      '0',
      NULL,
      '0',
      '0',
      '2',
      '1',
      NULL,
      '',
      NULL,
      '',
      '3',
      '3',
      '2',
      '4',
      '1',
      NULL,
      '',
      '2',
      '4',
      '1',
      '2',
      '0',
      '3',
      '3',
      '4',
      '4',
      '1',
      '4',
      '014',
      '43002241',
      22.590771,
      3,
      '0102000',
      3,
      29,
      NULL,
      NULL,
      '212101',
      4.858955,
      NULL,
      ' 2- 1-1984',
      NULL,
      109,
      NULL,
      8,
      0.396742,
      11,
      37.336738,
      7.876228,
      NULL,
      4.943084,
      7,
      0,
      11.406948,
      NULL,
      9.600030,
      1,
      3,
      7,
      25,
      1,
      8,
      6.274526,
      38,
      2.798165,
      0.646701,
      67.119998,
      NULL,
      48,
      102.182050,
      109.345372,
      105,
      ' 9-16-1987',
      34,
      25,
      20.629409,
      NULL,
      NULL,
      143,
      ' 5-29-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.310060,
      18,
      19.770293,
      NULL,
      5.629662,
      4,
      ' 0-17-1991',
      0.603430,
      0,
      159.786713,
      2,
      1.753330,
      16.511555,
      0,
      0,
      26,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1993',
      45.403644,
      114.648415,
      NULL,
      36,
      NULL,
      73,
      102.949908,
      NULL,
      69,
      26,
      NULL,
      79.023244,
      ' 2- 4-1977',
      4,
      8,
      3.050446,
      25.199913,
      7,
      NULL,
      4,
      ' 5-15-2002',
      6,
      7.794965,
      NULL,
      1.420259,
      1.184483,
      4,
      10,
      14.354412,
      0.691545,
      NULL,
      NULL,
      0.285749,
      10,
      2.907673,
      NULL,
      9,
      5.494918,
      4,
      0,
      0.179751,
      1.165234,
      ' 2- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      14.958754,
      7,
      ' 4-19-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-10-1998',
      37.141017,
      ' 0-17-1990',
      2.029852,
      8,
      '11-20-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      7.708213,
      ' 3- 1-1991',
      51.309350,
      26.629850,
      29,
      ' 6-22-1981',
      1.229727,
      NULL,
      ' 8- 4-1995',
      10.391554,
      196,
      0,
      74,
      ' 1-10-1985',
      43,
      NULL,
      23,
      ' 7- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


