set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6956684';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43241402',
      '44220330',
      '11241002',
      NULL,
      NULL,
      '41010401',
      '33240032',
      NULL,
      '14423242',
      '30440430',
      NULL,
      '24231033',
      '34004003',
      NULL,
      '24114312',
      '03434324',
      '44034212',
      '33340442',
      NULL,
      '42243340',
      '20002331',
      '23143304',
      '11134321',
      NULL,
      '31310420',
      '40042231',
      '12010133',
      '23123431',
      '30314113',
      '21304440',
      NULL,
      NULL,
      '43030242',
      '32121201',
      '03342200',
      '04004312',
      '34223323',
      '10321423',
      '01301030',
      '22020403',
      '32124220',
      '31334221',
      '31112304',
      '44313003',
      '102',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '312003',
      5,
      ' 8-25-1989',
      ' 5-22-1998',
      73.412228,
      NULL,
      30,
      NULL,
      20,
      0.739907,
      54,
      21,
      16,
      15,
      29.967404,
      NULL,
      4.492394,
      8.006791,
      29.482206,
      NULL,
      7,
      8.524708,
      10,
      NULL,
      30.890285,
      21.116675,
      NULL,
      0,
      0.907998,
      31.187231,
      NULL,
      6.447416,
      200.388391,
      167,
      196,
      ' 0-16-1993',
      40.079462,
      17.780412,
      27,
      15,
      35,
      NULL,
      ' 0- 9-2003',
      NULL,
      3.785975,
      1.011981,
      5.807097,
      NULL,
      6.003695,
      3.438270,
      4.536925,
      0,
      0,
      6.615467,
      1,
      0.116617,
      5.394163,
      NULL,
      1.599998,
      3,
      0.483089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-27-1992',
      11,
      21.761222,
      11,
      3.832737,
      8.171170,
      5,
      ' 6- 0-1986',
      3.528733,
      3,
      160,
      1,
      2,
      66.619552,
      0.366871,
      NULL,
      65.220273,
      NULL,
      NULL,
      NULL,
      ' 6-13-2001',
      59,
      NULL,
      35,
      58,
      96.582594,
      112,
      56.052668,
      100,
      92.673651,
      43.931978,
      10.434841,
      NULL,
      ' 9-24-1984',
      6.431161,
      28,
      8.402993,
      85.024102,
      5.516939,
      NULL,
      NULL,
      ' 2-27-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.819329,
      NULL,
      ' 2-21-1984',
      NULL,
      NULL,
      NULL,
      56.559263,
      ' 6-22-1979',
      14.503949,
      NULL,
      17,
      12.461174,
      ' 1-11-1994',
      115.314147,
      97,
      ' 9- 2-1999',
      0,
      2.475014,
      '11-26-1984',
      NULL,
      NULL,
      NULL,
      2,
      3,
      18.004819,
      '10- 2-1981',
      42,
      NULL,
      19.409879,
      '11-18-1982',
      0.136350,
      1.366384,
      ' 3-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


