set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '4',
      '4',
      NULL,
      '0',
      '1',
      NULL,
      '3',
      '1',
      '2',
      '4',
      '0',
      '2',
      '0',
      '1',
      '0',
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '2',
      NULL,
      '',
      '2',
      NULL,
      '0',
      '0',
      '2',
      '0',
      '1',
      '',
      '',
      '1',
      '0',
      '2',
      '4',
      '1',
      '1',
      '3',
      NULL,
      '4',
      NULL,
      NULL,
      '402',
      '44142412',
      NULL,
      68.574906,
      '2243042',
      1.076345,
      1.058443,
      1,
      0,
      '032320',
      2.240347,
      ' 6- 8-1988',
      ' 9-20-2003',
      66,
      105.113462,
      17,
      11,
      17.555761,
      3.782119,
      10,
      2.949569,
      15,
      3.074897,
      26,
      4.284233,
      5.447511,
      0,
      1.437186,
      5,
      12,
      NULL,
      40.488017,
      5.157058,
      13.376562,
      10.664993,
      70,
      14.160492,
      NULL,
      37.580517,
      77.311528,
      41.718440,
      76,
      160.377357,
      120,
      ' 7-12-1991',
      14,
      NULL,
      4,
      2,
      112,
      NULL,
      ' 6- 2-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.373093,
      7.624516,
      3,
      NULL,
      '11-10-1997',
      0,
      0,
      179.327730,
      0,
      2.428120,
      90,
      3,
      0.559381,
      61,
      NULL,
      NULL,
      NULL,
      '11-11-1990',
      42.608122,
      19.813726,
      NULL,
      4.567364,
      15,
      56,
      NULL,
      26,
      NULL,
      70.459700,
      11.767313,
      NULL,
      ' 3-23-1997',
      3,
      2.647840,
      NULL,
      0.518094,
      17,
      4.712988,
      1,
      ' 3- 1-1987',
      19,
      2.583135,
      NULL,
      1,
      15.698450,
      18,
      9,
      NULL,
      8,
      1,
      18,
      1.569049,
      NULL,
      0,
      9,
      8,
      12,
      7,
      0.990144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      29.127865,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      NULL,
      ' 7-26-1980',
      12.260555,
      2.844020,
      ' 1- 9-2003',
      21.620610,
      99,
      '10-12-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.881564,
      ' 8-16-1996',
      21.175659,
      7,
      7,
      ' 9- 4-1984',
      0,
      19,
      ' 7- 6-1994',
      NULL,
      12.270475,
      5,
      NULL,
      ' 1-10-2002',
      40,
      1.382703,
      122,
      ' 7- 7-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


