set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '3',
      NULL,
      '0',
      '1',
      '2',
      '2',
      '1',
      NULL,
      '1',
      '1',
      '2',
      '0',
      '3',
      '0',
      '1',
      '4',
      '0',
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      '1',
      '0',
      '',
      '',
      '3',
      '4',
      '0',
      '3',
      '3',
      '2',
      '1',
      '0',
      '4',
      '2',
      '0',
      '443',
      '41023030',
      91,
      88,
      '2300433',
      0.048764,
      1.595166,
      3,
      1,
      '214320',
      1.897936,
      ' 6-21-1984',
      ' 4-12-1998',
      NULL,
      202,
      23,
      NULL,
      20,
      7.592844,
      NULL,
      11,
      4.593055,
      6,
      26.418285,
      19.632931,
      28,
      11.773499,
      2,
      NULL,
      38.117134,
      8,
      7.728865,
      NULL,
      3,
      15.768341,
      42.680308,
      4.546251,
      3.825549,
      20.037988,
      109.969469,
      96,
      30,
      NULL,
      165.981104,
      NULL,
      46,
      25,
      NULL,
      13,
      139,
      43.482650,
      '11- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      NULL,
      10.276892,
      NULL,
      2.357080,
      '10-29-1980',
      1.267094,
      1,
      NULL,
      3,
      2.907179,
      43,
      1,
      3.843780,
      80.265181,
      NULL,
      NULL,
      NULL,
      ' 2-26-1980',
      50,
      52,
      11,
      51.325392,
      24.107280,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      27,
      6,
      NULL,
      11.865996,
      8.167642,
      12.333134,
      31,
      28,
      7.331982,
      0,
      ' 2-16-1997',
      16,
      10.626283,
      '11-24-1984',
      3.391962,
      13.755066,
      7.802276,
      NULL,
      NULL,
      NULL,
      NULL,
      5.821710,
      0,
      28,
      0.781323,
      0,
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      110,
      '10- 0-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-25-1999',
      20,
      ' 2-19-1990',
      12.172767,
      10,
      ' 9-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4,
      ' 5-19-2000',
      28.736751,
      NULL,
      3,
      ' 8-22-1986',
      NULL,
      24,
      '10-22-1980',
      5,
      26.649115,
      1,
      77,
      ' 0-20-1980',
      53,
      NULL,
      43,
      ' 2-15-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


