set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9709528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0020',
      '02024201',
      '21302442',
      '01414042',
      '32344033',
      '33114342',
      '43024111',
      '21011123',
      '13301141',
      '40122233',
      '24220003',
      '14132131',
      '03420411',
      '34222114',
      NULL,
      NULL,
      '23441113',
      '24442004',
      '20424401',
      '33024041',
      '40340222',
      '21011334',
      '04114433',
      '12322331',
      '40404122',
      NULL,
      '34044330',
      '34100110',
      '43122422',
      NULL,
      '43103121',
      NULL,
      '21014112',
      NULL,
      '11333412',
      '11403013',
      '13104424',
      '43120121',
      '32142123',
      NULL,
      NULL,
      '10212010',
      '32024013',
      '13022340',
      NULL,
      '444',
      '14',
      NULL,
      5.501128,
      '3432001',
      1,
      1,
      0,
      NULL,
      '102031',
      3,
      ' 2- 5-2001',
      ' 9-20-2001',
      0,
      62,
      28.685186,
      9.450543,
      2,
      NULL,
      24,
      2.521607,
      2,
      7,
      NULL,
      7.721637,
      39,
      NULL,
      2,
      10,
      NULL,
      11.800676,
      71.402204,
      16.259844,
      NULL,
      10,
      93,
      3.493501,
      0.688003,
      72,
      113.295716,
      NULL,
      139.246214,
      183.130183,
      11.736149,
      NULL,
      43,
      41.654700,
      13,
      8.264697,
      103,
      NULL,
      ' 0-15-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.863315,
      49,
      12.661492,
      NULL,
      10.126425,
      NULL,
      ' 5-14-1986',
      NULL,
      1.331981,
      177.041047,
      0.470863,
      NULL,
      29.849884,
      0,
      0,
      54.299497,
      NULL,
      NULL,
      NULL,
      '10-26-1991',
      71,
      52.715364,
      9.238867,
      83,
      NULL,
      NULL,
      23.783817,
      16,
      65,
      0.905644,
      NULL,
      10,
      ' 2-14-2003',
      5,
      0.701156,
      4.459074,
      26.321115,
      49.651450,
      85,
      4.818622,
      ' 7- 3-1976',
      20.974199,
      4,
      ' 0- 0-1977',
      10.058588,
      4,
      1,
      11,
      23.292217,
      9.028787,
      0.580309,
      6.156528,
      1.043520,
      NULL,
      NULL,
      3,
      5.827246,
      7.668627,
      8.369432,
      4.162739,
      0,
      1,
      ' 3- 3-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      NULL,
      ' 9-12-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-12-1975',
      10.263731,
      ' 1- 0-1995',
      3,
      16.490941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      ' 8-25-1980',
      16.687270,
      NULL,
      38.411399,
      ' 3-21-1976',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


