set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7054455';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2220',
      NULL,
      '43120424',
      '41420224',
      '33200032',
      '11131430',
      NULL,
      '11121044',
      '22200120',
      '13022330',
      '44400033',
      '34240343',
      '41442122',
      '10421200',
      '01211001',
      '40142203',
      '00430130',
      '01000110',
      '31210134',
      '34100101',
      '00314210',
      '31311321',
      '42313021',
      '13121011',
      '31122342',
      '13223231',
      '00433121',
      NULL,
      '34442400',
      '42044040',
      '20043224',
      '23323423',
      '42301233',
      NULL,
      '01142442',
      NULL,
      '20033240',
      NULL,
      '42041000',
      NULL,
      '10420240',
      '12344101',
      '14412224',
      '24023420',
      NULL,
      '230',
      '30',
      NULL,
      NULL,
      '0440113',
      2.873347,
      1.293500,
      NULL,
      NULL,
      NULL,
      5.358420,
      NULL,
      ' 9-14-2002',
      10.145643,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      69.107598,
      13.610155,
      8,
      2.202748,
      NULL,
      5,
      12,
      9,
      14,
      5.648971,
      1,
      5.265993,
      10,
      5.325531,
      29,
      NULL,
      NULL,
      3.006231,
      NULL,
      30.082075,
      NULL,
      NULL,
      165,
      96.790615,
      25,
      '10-17-1988',
      39,
      17,
      11,
      6,
      68.535871,
      80.075007,
      ' 9- 3-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.144087,
      NULL,
      NULL,
      1.152362,
      34.038017,
      NULL,
      NULL,
      1,
      1,
      108,
      1,
      1.393974,
      100,
      NULL,
      1.472999,
      23.355935,
      0.999553,
      NULL,
      13,
      NULL,
      6.968680,
      33,
      NULL,
      NULL,
      70,
      NULL,
      NULL,
      61,
      53,
      51,
      22.046229,
      55,
      NULL,
      13,
      6.252437,
      14.753153,
      28,
      33,
      0,
      3,
      ' 0-15-1985',
      17,
      4.587846,
      ' 6-15-1997',
      1,
      NULL,
      15.511894,
      21,
      NULL,
      1.151958,
      3.282417,
      8,
      0.948492,
      77,
      0.359608,
      1,
      3,
      28.141699,
      2.062549,
      NULL,
      4,
      0.445336,
      '10- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.088692,
      2,
      2.033835,
      NULL,
      0.848805,
      272.438230,
      '11-24-1984',
      NULL,
      32.883002,
      1.707170,
      11,
      ' 0-28-1989',
      18.366530,
      0.222567,
      NULL,
      ' 4-25-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


