set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8331407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10412400',
      NULL,
      '14034333',
      '31412201',
      '32214111',
      '22211004',
      '41421142',
      '40344142',
      '34122311',
      '23041434',
      '10330213',
      '02311040',
      NULL,
      '03314411',
      '04331430',
      '10402032',
      '20340224',
      '03232010',
      NULL,
      '41213244',
      '02202304',
      '03323311',
      '31202102',
      '33110243',
      '30124134',
      '12413404',
      '40012120',
      '22101403',
      '13232420',
      '23130414',
      '31321203',
      '34142410',
      NULL,
      NULL,
      '24214012',
      '20000404',
      '33411102',
      NULL,
      NULL,
      '34040301',
      '42023123',
      '31103243',
      '02304400',
      '12433340',
      '',
      '',
      NULL,
      NULL,
      '3412144',
      NULL,
      0.894004,
      2,
      NULL,
      '230343',
      NULL,
      NULL,
      ' 5- 3-2003',
      NULL,
      NULL,
      3.296864,
      0,
      16.211359,
      6.513458,
      104.040466,
      19.231357,
      19,
      10,
      14,
      24.025855,
      14,
      12,
      5.935107,
      10,
      21,
      2,
      73,
      NULL,
      37,
      NULL,
      89.570091,
      19,
      NULL,
      10,
      188.317853,
      107,
      156.759079,
      265.073149,
      129.013341,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484873,
      NULL,
      1.019865,
      1.549000,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.377912,
      0.088565,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-20-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-12-1995',
      98,
      27,
      17.339152,
      44.945349,
      7,
      64.098003,
      46,
      72,
      70,
      32.913088,
      57.320041,
      NULL,
      NULL,
      9,
      13,
      16,
      NULL,
      9.406245,
      NULL,
      3,
      ' 0-29-1979',
      7,
      13.653936,
      ' 6- 6-1978',
      17.676614,
      NULL,
      NULL,
      20,
      25.739585,
      13.629552,
      NULL,
      19,
      NULL,
      91.165327,
      1.845117,
      4,
      19.467899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.320206,
      40,
      NULL,
      ' 5-22-1981',
      0,
      97,
      ' 2- 3-1991',
      NULL,
      46,
      11.178753,
      NULL,
      ' 3-29-1984',
      40,
      0.118511,
      108,
      ' 0- 9-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      90.658997,
      39,
      14.792461,
      NULL,
      6.910267,
      12,
      NULL,
      0.660026,
      1.372083,
      43.801180,
      NULL,
      NULL,
      NULL,
      0.071196,
      1,
      40,
      0.424742,
      0.994964,
      3.914266,
      NULL,
      29.580396,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.813831,
      NULL,
      NULL,
      NULL,
      17.765378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640664,
      NULL,
      1.968336,
      0.743895,
      NULL,
      35.169050,
      19.118550,
      36.301341,
      NULL,
      NULL,
      NULL,
      NULL,
      16.066826,
      0.350739,
      0,
      NULL,
      7,
      NULL,
      1.883893,
      1,
      NULL,
      ' 3- 2-2003',
      ' 1-28-1991',
      ' 1-19-1993',
      NULL,
      ' 6- 2-1986',
      NULL,
      ' 9-29-1998',
      NULL);
commit;
end;
/


