set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8009748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4110',
      '32310211',
      '13324232',
      '12320131',
      '21312233',
      NULL,
      '14042241',
      '41412320',
      NULL,
      '44430424',
      '20420133',
      '33400230',
      NULL,
      '21121031',
      '40332144',
      '34224022',
      '40244042',
      '24441442',
      NULL,
      NULL,
      '04042433',
      NULL,
      '30004230',
      NULL,
      '31441143',
      '10210144',
      '33211131',
      '41411221',
      '13412004',
      '33410302',
      '34024130',
      '33102210',
      '00301312',
      '40023331',
      NULL,
      '12343334',
      '11443230',
      NULL,
      '40143212',
      NULL,
      '21410011',
      '01210040',
      NULL,
      '20343004',
      NULL,
      '204',
      '04',
      12.582723,
      8,
      '2104141',
      1,
      0,
      NULL,
      NULL,
      '102330',
      4,
      '10- 8-1981',
      ' 1-10-2000',
      84.437983,
      33,
      4,
      5,
      NULL,
      17.835902,
      8.244141,
      NULL,
      NULL,
      6.697943,
      21.980073,
      2,
      0,
      10.080288,
      27.518140,
      8,
      10.527345,
      3.089702,
      40.494752,
      9,
      33.146506,
      NULL,
      81.895328,
      13.515886,
      1,
      39.904509,
      96.977065,
      1.683805,
      101.916497,
      25.943479,
      133.931865,
      ' 7- 6-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499596,
      NULL,
      NULL,
      NULL,
      NULL,
      143.175809,
      0,
      1,
      8,
      NULL,
      NULL,
      NULL,
      ' 3-18-1984',
      51,
      54,
      37,
      63.280466,
      3.907195,
      27.254946,
      35.539441,
      47,
      13.136589,
      24.765931,
      NULL,
      23.053496,
      '10- 7-1999',
      19.314133,
      7.701763,
      3,
      26.258655,
      67,
      51.277280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.823482,
      3.227253,
      NULL,
      9.345556,
      22.106996,
      7.218188,
      1.191000,
      25.497731,
      0,
      2,
      2.679345,
      0,
      24.655643,
      25,
      0.859475,
      1.228063,
      0,
      1,
      ' 9-25-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      ' 0- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      '10- 2-1977',
      9,
      24.042607,
      46.949515,
      ' 5-29-1988',
      1,
      NULL,
      ' 4- 9-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


