set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8801751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4412',
      '24414431',
      '22430114',
      '04131340',
      '21342100',
      '12024240',
      '41342033',
      NULL,
      '44102434',
      '34434343',
      '03314100',
      '41041341',
      '04142413',
      '11042132',
      '44220134',
      '04222434',
      '14012100',
      '23230231',
      NULL,
      NULL,
      '43140222',
      '32244420',
      '12031441',
      NULL,
      NULL,
      NULL,
      '14002122',
      '34320302',
      '34233142',
      '23402100',
      '41404040',
      '04104334',
      '42010212',
      '41412342',
      '20411413',
      '23424143',
      NULL,
      '02004133',
      '13423021',
      '03011332',
      '01111333',
      '43211214',
      '21330224',
      '21201023',
      '32414432',
      '',
      '',
      NULL,
      NULL,
      '1044044',
      NULL,
      NULL,
      3,
      NULL,
      '141303',
      3.728748,
      ' 2- 6-1998',
      ' 5-20-1986',
      NULL,
      NULL,
      5.046052,
      18.434158,
      10.734309,
      NULL,
      97,
      0.653342,
      28.557432,
      21,
      37.615250,
      11,
      NULL,
      NULL,
      NULL,
      16.019568,
      NULL,
      NULL,
      37,
      19,
      7.188092,
      8.245122,
      12.506217,
      NULL,
      NULL,
      NULL,
      135.849519,
      NULL,
      NULL,
      NULL,
      128.389488,
      ' 7-17-1995',
      NULL,
      0,
      31,
      26.564270,
      NULL,
      NULL,
      ' 5-18-1993',
      1.683528,
      1.686551,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185633,
      1,
      1,
      NULL,
      0.512323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-16-1984',
      14.324604,
      23,
      26.244146,
      NULL,
      22.638312,
      35,
      96.793987,
      57,
      NULL,
      112,
      16,
      11,
      '10-24-1976',
      16,
      8.203507,
      18.075092,
      1,
      18,
      46,
      9.117291,
      ' 7-14-1997',
      20.526802,
      15,
      ' 4-16-1993',
      8.109690,
      4.223022,
      16,
      7.713187,
      25,
      1.942608,
      NULL,
      14.287195,
      NULL,
      32,
      1.901495,
      0.080272,
      20.157284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-25-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      8,
      '10-10-1993',
      0.412294,
      72,
      ' 3- 1-2003',
      2,
      NULL,
      NULL,
      21,
      '11-28-1992',
      60,
      0.587879,
      111,
      ' 8- 6-2000',
      NULL,
      NULL,
      NULL,
      66,
      0.342306,
      NULL,
      103.192297,
      97.029332,
      57.200384,
      10,
      0.384511,
      2.794527,
      3.176284,
      4.341348,
      167.952567,
      1,
      0,
      25.372292,
      0,
      0.504672,
      48.750197,
      0.234727,
      NULL,
      97.673747,
      0.156218,
      0.040003,
      91,
      35,
      29.000232,
      50,
      1,
      4,
      1.131297,
      1,
      NULL,
      1.204813,
      0,
      0,
      NULL,
      104.350381,
      175.261706,
      15,
      NULL,
      129.003471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381352,
      102,
      NULL,
      NULL,
      115.320114,
      NULL,
      1,
      35.095483,
      153,
      NULL,
      0,
      NULL,
      15.573376,
      1.401759,
      1.949473,
      1.110926,
      NULL,
      1,
      0,
      1,
      NULL,
      ' 4-19-2001',
      ' 6-12-1999',
      ' 8- 1-1977',
      NULL,
      ' 4-20-1976',
      ' 5-13-1995',
      ' 8-19-1999',
      NULL);
commit;
end;
/


