set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '00144240',
      NULL,
      '03220202',
      NULL,
      '30312411',
      '43104422',
      '13404042',
      '30100424',
      NULL,
      '02231200',
      '03431004',
      '04042212',
      '33203240',
      '02420223',
      NULL,
      '02131321',
      '40024312',
      NULL,
      '32220424',
      NULL,
      '03030031',
      '24241023',
      '02232440',
      '20011313',
      '43133420',
      '04034311',
      '40004402',
      '22001241',
      '33423231',
      '10002410',
      '22014343',
      '23120043',
      '32420213',
      '40024142',
      '24312111',
      NULL,
      '41310011',
      '10113100',
      '40333431',
      '22103244',
      '21110413',
      NULL,
      '21204322',
      '',
      '',
      NULL,
      NULL,
      '1102120',
      2.989064,
      0,
      NULL,
      NULL,
      '101041',
      0,
      ' 8- 8-2003',
      NULL,
      73.303220,
      NULL,
      1,
      3.674107,
      2,
      8,
      11.180074,
      NULL,
      1,
      0,
      NULL,
      NULL,
      30,
      6.217960,
      23,
      2.363558,
      6,
      5,
      5,
      NULL,
      42.845411,
      10,
      NULL,
      NULL,
      NULL,
      55.833629,
      NULL,
      19,
      136,
      79.859765,
      NULL,
      ' 6-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.545480,
      9,
      1.627352,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583381,
      0,
      4.458738,
      NULL,
      NULL,
      0.053887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1978',
      77.256706,
      NULL,
      NULL,
      5.472454,
      37,
      21,
      41.185591,
      3,
      NULL,
      16,
      NULL,
      1,
      ' 0-17-1976',
      34,
      5,
      6.643522,
      44,
      NULL,
      39.121536,
      9,
      ' 4- 9-1988',
      5.741325,
      5,
      ' 0-18-1993',
      12.383969,
      9.100226,
      NULL,
      12.701296,
      13.886961,
      6.153476,
      NULL,
      4.623071,
      NULL,
      1.679654,
      1,
      1.190262,
      8.893170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      11,
      ' 7-25-1984',
      1.855800,
      NULL,
      ' 5- 6-1996',
      3.316596,
      20,
      NULL,
      4.687587,
      ' 9-25-1981',
      60,
      1,
      2.669200,
      ' 1-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      1.354140,
      NULL,
      NULL,
      55.398555,
      0.198217,
      8,
      6.656681,
      4.332010,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      1.454220,
      NULL,
      3.680641,
      NULL,
      265.788678,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.660896,
      0,
      1.195210,
      0.746775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945504,
      NULL,
      NULL,
      0.133187,
      NULL,
      33.333477,
      17,
      33,
      NULL,
      NULL,
      6,
      NULL,
      6,
      9.321536,
      1.716068,
      NULL,
      1.644220,
      2.934225,
      0.186641,
      1,
      NULL,
      ' 1-26-1998',
      '11-27-1981',
      ' 6- 5-1979',
      '10- 0-1985',
      NULL,
      ' 1-19-1985',
      ' 1-11-1990',
      NULL);
commit;
end;
/


