set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2141',
      '12322000',
      '30424423',
      '32440103',
      NULL,
      '32443110',
      '21444443',
      NULL,
      '13210441',
      '43231031',
      '01110224',
      '44412034',
      '23302021',
      '33304211',
      '10203013',
      '14244014',
      NULL,
      '20031000',
      '03001222',
      '30012413',
      '34410312',
      '10432231',
      '24344100',
      '02023221',
      '30031442',
      '11211114',
      '23101000',
      '43311222',
      NULL,
      NULL,
      NULL,
      '34021220',
      '21000214',
      '01331313',
      NULL,
      '22023242',
      '24041302',
      '40012123',
      NULL,
      NULL,
      '11110314',
      '30204304',
      '20304000',
      '20101120',
      '40303020',
      '',
      NULL,
      NULL,
      NULL,
      '3134433',
      1,
      0.757199,
      0,
      NULL,
      '333440',
      NULL,
      ' 1-28-1977',
      ' 2- 0-1989',
      42.623025,
      NULL,
      12,
      0.801319,
      16.555737,
      4.470766,
      NULL,
      7,
      NULL,
      1,
      20,
      4.917047,
      20,
      8,
      18.560994,
      15,
      14.534201,
      9,
      NULL,
      6,
      23.986143,
      4,
      140,
      25.313017,
      NULL,
      37.156399,
      161.322374,
      71.067870,
      153.813214,
      NULL,
      109.247627,
      ' 8-19-2003',
      35,
      18,
      NULL,
      16.412387,
      114.300571,
      158,
      ' 0-23-1999',
      1.480924,
      2.957237,
      1.967460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049936,
      0.575062,
      5.328530,
      NULL,
      0,
      1.832742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1984',
      65,
      52,
      77,
      80.631415,
      14,
      NULL,
      40.187944,
      NULL,
      66,
      22.412058,
      91,
      NULL,
      ' 0-13-2000',
      1.841204,
      5.017899,
      22,
      57,
      19,
      NULL,
      6,
      ' 3- 6-2001',
      3.114378,
      3.496910,
      ' 9-20-1985',
      NULL,
      9,
      19,
      21,
      7,
      7.548473,
      NULL,
      6.278540,
      NULL,
      60.685332,
      0,
      1.853548,
      16.322216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.685020,
      15,
      48.591868,
      NULL,
      NULL,
      73,
      ' 2- 4-1976',
      4,
      35.922559,
      19,
      43,
      ' 4- 1-2001',
      NULL,
      NULL,
      148.102380,
      ' 4-12-1975',
      NULL,
      NULL,
      NULL,
      75.238852,
      82,
      127.625560,
      10,
      45.899047,
      160.919837,
      60,
      NULL,
      40,
      4,
      4.292789,
      57,
      0,
      1,
      36,
      0.113069,
      0.767898,
      7.701111,
      NULL,
      1,
      NULL,
      NULL,
      1,
      119.488960,
      54,
      NULL,
      NULL,
      0.620074,
      NULL,
      NULL,
      1.446692,
      0,
      1,
      0,
      1.946024,
      NULL,
      44.083777,
      23,
      20,
      NULL,
      49.962691,
      0.358902,
      1,
      NULL,
      NULL,
      4,
      13.070914,
      NULL,
      1.315560,
      41,
      4,
      NULL,
      1,
      NULL,
      83.336793,
      2.794930,
      NULL,
      NULL,
      10,
      24,
      26.594860,
      47.906631,
      14.649718,
      3,
      0,
      1.205904,
      NULL,
      0,
      1.276397,
      3,
      77,
      NULL,
      NULL,
      ' 9- 3-1976',
      ' 2-20-1986',
      NULL,
      ' 9- 8-1995',
      '10-15-2002',
      NULL);
commit;
end;
/


