set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4204',
      '31434034',
      '33114223',
      '40421413',
      '12233212',
      '32314041',
      '11031410',
      '43240341',
      NULL,
      '21410103',
      NULL,
      NULL,
      NULL,
      '10243224',
      '31314333',
      '14414431',
      '12010432',
      NULL,
      '21343211',
      NULL,
      '23101201',
      '41042321',
      NULL,
      '12230441',
      '14301311',
      '04121242',
      NULL,
      NULL,
      '32212200',
      '20440331',
      '12440123',
      '23043344',
      '30420240',
      '04030241',
      '22312442',
      NULL,
      '30414130',
      '00003234',
      '03340424',
      '11341314',
      '21424241',
      '34420333',
      '32240422',
      '01314213',
      '24112321',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.265896,
      1,
      NULL,
      '433143',
      NULL,
      ' 1-11-1980',
      ' 7-11-1994',
      43.806963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      48,
      7.644147,
      2,
      129.198221,
      89.276829,
      ' 2- 1-1988',
      0,
      5.566311,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892608,
      NULL,
      3.240505,
      0.838219,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 5-1974',
      79.628902,
      73,
      44,
      8.487359,
      76,
      NULL,
      102,
      NULL,
      38,
      24.641310,
      40,
      65,
      ' 7-29-1996',
      18.177873,
      19,
      14,
      NULL,
      58.000363,
      NULL,
      11,
      '10- 9-1976',
      1.924432,
      3.680244,
      NULL,
      NULL,
      1.096653,
      2,
      9,
      3.165927,
      11,
      NULL,
      7,
      NULL,
      63,
      NULL,
      3.693291,
      9.563431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      101.309325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.767237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.115045,
      NULL,
      1,
      55.750650,
      NULL,
      3,
      62.889249,
      1,
      2.121807,
      145,
      79,
      NULL,
      NULL,
      1,
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      82,
      1.162005,
      0.517379,
      38.496478,
      1.196145,
      0.246231,
      6,
      NULL,
      0.377787,
      20,
      3,
      57,
      1.731583,
      NULL,
      3.264467,
      23.200726,
      9,
      17.775217,
      45,
      NULL,
      NULL,
      NULL,
      8,
      8,
      0.736318,
      5,
      1.969869,
      1.675249,
      1.097513,
      1.941179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


