set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43334002',
      '41111012',
      '33331441',
      '42130334',
      '31032203',
      '13414232',
      '22043034',
      '14340242',
      '24244324',
      '20410114',
      '40322023',
      '10312333',
      '03431424',
      '14230032',
      '33230104',
      NULL,
      '12223120',
      '00412340',
      '20122413',
      '32343212',
      NULL,
      '42200224',
      NULL,
      NULL,
      '14421142',
      '43130344',
      '02042420',
      NULL,
      NULL,
      '00401434',
      NULL,
      '02040132',
      '03210040',
      '33240013',
      '04221110',
      '01114430',
      '04403224',
      '32340044',
      '24033342',
      '42221131',
      '04120320',
      NULL,
      '34232013',
      '44214401',
      NULL,
      '',
      NULL,
      NULL,
      '4240122',
      1,
      NULL,
      0,
      NULL,
      '202421',
      2.050447,
      NULL,
      ' 7-29-1997',
      10,
      NULL,
      32,
      13,
      NULL,
      20,
      40.616103,
      10.971494,
      5,
      16,
      2,
      8.710795,
      5,
      4.044269,
      1,
      0.859802,
      0,
      4.027969,
      27,
      NULL,
      3.858333,
      7.579812,
      72.090103,
      21.519985,
      NULL,
      23,
      NULL,
      62.601608,
      NULL,
      160,
      147.669216,
      ' 6-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220690,
      NULL,
      0.020655,
      0.040976,
      NULL,
      NULL,
      NULL,
      NULL,
      0.505773,
      1,
      1,
      1.784411,
      1,
      1.837652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.167707,
      42,
      87,
      7.913798,
      87.383039,
      91,
      NULL,
      NULL,
      39,
      36,
      NULL,
      17,
      ' 6-28-1998',
      NULL,
      16.237529,
      6.153186,
      81.884602,
      NULL,
      4.888870,
      14.886785,
      ' 1-21-1987',
      5.781566,
      3.881148,
      ' 3-29-1998',
      6.960473,
      12.676971,
      13.901856,
      16,
      5.232686,
      5,
      NULL,
      3,
      NULL,
      13,
      1,
      1,
      3.617224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 7-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      ' 2-20-1992',
      1.799699,
      NULL,
      ' 5-17-1983',
      17.115569,
      NULL,
      5.065516,
      NULL,
      NULL,
      1,
      0.544738,
      8.420538,
      ' 3-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      197.193526,
      0,
      57,
      NULL,
      139.278555,
      NULL,
      4,
      6.435119,
      2.657302,
      13.380786,
      44.053378,
      0.091790,
      NULL,
      10,
      0.583800,
      3.303453,
      NULL,
      1.673626,
      1.404361,
      NULL,
      4.597850,
      NULL,
      196,
      NULL,
      NULL,
      NULL,
      1,
      40,
      0.791781,
      1,
      0.413796,
      3,
      0,
      1.246072,
      NULL,
      NULL,
      37.682374,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      75.251725,
      1.131369,
      4,
      64,
      12,
      19,
      12.125768,
      73,
      70.866649,
      NULL,
      NULL,
      NULL,
      4.054128,
      1,
      4.626866,
      4,
      NULL,
      NULL,
      1.364949,
      87.518685,
      NULL,
      NULL,
      ' 1-25-1992',
      NULL,
      ' 0-20-1974',
      NULL,
      ' 6-14-2002',
      NULL);
commit;
end;
/


