set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908560';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1024',
      NULL,
      '44110332',
      '03223134',
      '24021144',
      '10031420',
      '22214124',
      '23010234',
      NULL,
      '44310301',
      '13431333',
      '12424424',
      '12332223',
      '13042301',
      '12312334',
      '44042102',
      '24443402',
      NULL,
      '24041442',
      '00041222',
      '40402421',
      '13111424',
      NULL,
      '42133224',
      NULL,
      '32113112',
      '11104324',
      '31330434',
      '43334412',
      '21434423',
      '31424313',
      '12244431',
      '30023112',
      NULL,
      '41414210',
      NULL,
      NULL,
      '22124244',
      '12231204',
      '31030314',
      NULL,
      '02031202',
      '02144122',
      NULL,
      '23022331',
      '224',
      '22',
      42.543075,
      12,
      '4014001',
      NULL,
      63.326831,
      2,
      NULL,
      NULL,
      4.857289,
      '10- 3-2001',
      '10- 5-1981',
      80.258795,
      101.611399,
      14,
      15,
      NULL,
      NULL,
      86.005382,
      13.111921,
      9.067106,
      14,
      NULL,
      13,
      4,
      1.404576,
      29.732404,
      4.754075,
      NULL,
      9,
      10,
      8.613870,
      NULL,
      4.539774,
      65,
      28.401265,
      NULL,
      76.517041,
      113.593596,
      53,
      114.684817,
      NULL,
      135,
      ' 8-21-2000',
      37,
      17,
      10,
      16.785169,
      NULL,
      69,
      ' 0- 5-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      14.838212,
      NULL,
      9.894093,
      9,
      NULL,
      ' 9- 9-2002',
      0,
      0.089307,
      105,
      0,
      3,
      9,
      0.113306,
      NULL,
      99,
      NULL,
      NULL,
      NULL,
      ' 3- 8-2002',
      56,
      56.170428,
      NULL,
      23,
      NULL,
      NULL,
      10,
      27,
      15.555847,
      8,
      8,
      25,
      ' 8-17-2001',
      18.228310,
      11.746532,
      17.535677,
      52.347514,
      NULL,
      35,
      11.054914,
      ' 7-15-1996',
      17,
      10.117958,
      ' 8- 1-2003',
      1,
      4.023579,
      5.393382,
      NULL,
      6.165446,
      3,
      1,
      6.581900,
      0,
      NULL,
      1.925332,
      NULL,
      3.259474,
      27,
      3,
      NULL,
      1.918108,
      NULL,
      ' 5-22-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      124.321757,
      9.025728,
      NULL,
      NULL,
      NULL,
      NULL,
      8.953545,
      NULL,
      46,
      '10- 3-2001',
      8.547783,
      4.164801,
      ' 2-20-2001',
      1.271976,
      95.839361,
      ' 3-27-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      24.584742,
      '10-22-1991',
      44,
      19.710880,
      9,
      ' 6-21-1991',
      0,
      64.679787,
      ' 3-10-1982',
      16,
      32.336464,
      NULL,
      37.658299,
      NULL,
      26,
      NULL,
      16,
      '10- 9-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


