set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8500287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '3',
      NULL,
      '4',
      '0',
      '3',
      '1',
      '0',
      '1',
      '4',
      NULL,
      '3',
      '4',
      '0',
      '0',
      '3',
      '3',
      NULL,
      '3',
      '2',
      '2',
      '4',
      '3',
      '',
      '0',
      '',
      '4',
      '1',
      '1',
      '1',
      '4',
      '',
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      '1',
      '4',
      '3',
      NULL,
      '0',
      '0',
      '3',
      NULL,
      '31012413',
      36,
      39,
      '2020220',
      0,
      0,
      2,
      NULL,
      '114432',
      6,
      '11-29-2002',
      ' 8- 7-2003',
      8.273021,
      139.987863,
      NULL,
      20,
      NULL,
      7,
      1,
      4.337087,
      NULL,
      21.160590,
      26.950254,
      6,
      23,
      0,
      NULL,
      3,
      20.802063,
      NULL,
      22.436316,
      13.157963,
      14.314856,
      9.358616,
      18.158033,
      13.275712,
      1,
      60,
      204,
      46,
      69,
      122.348724,
      167.373460,
      ' 6-24-2002',
      11,
      26,
      28.938519,
      7,
      35.803988,
      73.727965,
      ' 7-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822209,
      5,
      9,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      1,
      0,
      58,
      1,
      0.115743,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      16.531437,
      19.946662,
      NULL,
      NULL,
      21.324146,
      31.867208,
      24,
      35.980249,
      27,
      7.365314,
      NULL,
      NULL,
      NULL,
      22.182182,
      NULL,
      2,
      NULL,
      51,
      20,
      9.193535,
      ' 1-13-1995',
      5.271995,
      21.515814,
      NULL,
      1,
      15,
      13,
      7.042188,
      11,
      3,
      1.873257,
      9,
      1,
      114.567640,
      NULL,
      1,
      NULL,
      NULL,
      9,
      0.552167,
      NULL,
      0.238435,
      ' 5-25-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      10.790006,
      '10-12-1984',
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      34.856672,
      ' 7-28-1998',
      NULL,
      0,
      ' 7- 5-1979',
      61,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      8,
      ' 2-16-1995',
      62,
      8,
      13,
      NULL,
      1.575050,
      76.400461,
      NULL,
      13,
      30,
      0.454354,
      24,
      '11-10-1976',
      53.683211,
      NULL,
      161.658408,
      ' 0- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


