set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9850425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '1',
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      '4',
      '2',
      '1',
      '2',
      '0',
      '2',
      '1',
      '4',
      '4',
      '4',
      '0',
      '1',
      '3',
      '0',
      '',
      '4',
      NULL,
      '3',
      '4',
      '0',
      '2',
      '0',
      '',
      '',
      '0',
      '4',
      '1',
      '3',
      NULL,
      NULL,
      '1',
      NULL,
      '2',
      '3',
      NULL,
      '213',
      '02134042',
      44,
      16.787866,
      NULL,
      1.059613,
      1,
      1,
      NULL,
      NULL,
      NULL,
      ' 2-19-1981',
      ' 4-10-1980',
      107,
      61,
      16.794755,
      3.426953,
      NULL,
      12.469208,
      42.246520,
      NULL,
      0.297756,
      0.829202,
      NULL,
      9,
      35.301239,
      NULL,
      11.511086,
      11,
      1.716616,
      6.560827,
      17.908920,
      5,
      25.721901,
      1.882574,
      NULL,
      4,
      1,
      86.014987,
      113.194942,
      45,
      54,
      132,
      53,
      ' 4- 0-1978',
      48,
      NULL,
      3,
      10.691196,
      53,
      100.209428,
      '10-24-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      7,
      53.250683,
      13.807817,
      1.169925,
      ' 0-25-1992',
      1,
      3.497679,
      38.382236,
      1.662340,
      3,
      NULL,
      NULL,
      2.643638,
      30,
      NULL,
      NULL,
      NULL,
      ' 8-20-1997',
      45,
      20.967721,
      NULL,
      54.772395,
      11,
      93.700525,
      16.006790,
      80.308307,
      75.769206,
      2,
      39.677300,
      36.221005,
      NULL,
      18.962641,
      22,
      0.636375,
      36.926370,
      37,
      NULL,
      NULL,
      ' 9-28-1989',
      NULL,
      5,
      ' 1-19-1990',
      2,
      3.397740,
      6.184175,
      3,
      7.320687,
      0.152925,
      0,
      NULL,
      0,
      35,
      NULL,
      1,
      0,
      9.879279,
      0.891535,
      0,
      1,
      0.371802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.071430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      ' 7- 5-1979',
      NULL,
      '10-22-1993',
      NULL,
      5.699996,
      '11-27-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      17.983257,
      ' 7-13-1999',
      22.671177,
      9.039578,
      9,
      ' 5-24-1992',
      4.733779,
      92.472971,
      ' 3- 0-1994',
      11.392764,
      20.273391,
      17,
      NULL,
      ' 8- 1-1990',
      15.922166,
      0,
      144.965288,
      '10-25-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


