set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9850425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '0',
      NULL,
      '1',
      '4',
      '1',
      '4',
      '2',
      NULL,
      '1',
      '1',
      NULL,
      '1',
      '4',
      '3',
      '4',
      '4',
      '2',
      '2',
      '2',
      '3',
      '2',
      '4',
      '',
      '3',
      '',
      NULL,
      '4',
      '4',
      '2',
      '2',
      '',
      '',
      '2',
      '4',
      '3',
      '4',
      '1',
      '4',
      '0',
      '0',
      '1',
      NULL,
      '1',
      '342',
      '01413342',
      46,
      58,
      '1342241',
      NULL,
      NULL,
      3,
      0,
      '243414',
      2.559221,
      ' 3- 2-1988',
      ' 4-12-1975',
      38.566289,
      111,
      30,
      NULL,
      28,
      6,
      49.059223,
      NULL,
      NULL,
      0.968752,
      8,
      11,
      29.852888,
      NULL,
      25.565539,
      4.264893,
      6.444613,
      13,
      27.795746,
      0,
      7.034361,
      6,
      NULL,
      9.234283,
      1.264860,
      41.163562,
      57,
      52.535392,
      127.945331,
      28,
      72.963055,
      NULL,
      NULL,
      56.364307,
      24.579561,
      30.857181,
      NULL,
      15.624091,
      ' 6-15-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.369682,
      NULL,
      16,
      NULL,
      20.229827,
      NULL,
      ' 5- 1-1998',
      NULL,
      NULL,
      92.286874,
      1.279338,
      3.440484,
      64.134532,
      0.119218,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1975',
      43,
      24.691624,
      81,
      26.067660,
      33,
      115,
      79.423403,
      50,
      96.106300,
      41.633413,
      79.546641,
      35,
      '10- 5-1991',
      3.953398,
      2.650828,
      18,
      20,
      46,
      0.420892,
      NULL,
      '11- 6-1984',
      20,
      NULL,
      '10-14-1975',
      10.755020,
      13.619530,
      15,
      14.049608,
      7,
      5.043906,
      0.385556,
      15,
      NULL,
      94.120245,
      0.177768,
      NULL,
      2,
      28,
      2.400354,
      0,
      NULL,
      0.502552,
      ' 2- 6-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      48.766840,
      ' 0- 7-1997',
      NULL,
      NULL,
      NULL,
      45.501049,
      NULL,
      1.199547,
      '10-27-1995',
      2.717518,
      1,
      ' 4-17-1986',
      89.397980,
      63,
      ' 9-17-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.961935,
      NULL,
      47,
      25,
      27,
      NULL,
      NULL,
      88.099833,
      NULL,
      0.097101,
      NULL,
      11,
      4,
      ' 1- 9-1974',
      6,
      0,
      166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


