set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3431',
      '41434102',
      NULL,
      '41044010',
      '02342002',
      NULL,
      '20421103',
      '13222323',
      '33012031',
      '11340204',
      NULL,
      '14032100',
      '01422112',
      '11021321',
      '44320342',
      '03214311',
      '41411004',
      '02421123',
      NULL,
      '11230433',
      '20321341',
      '01212312',
      NULL,
      '43402001',
      NULL,
      '32233430',
      '04022031',
      '44211413',
      '22121200',
      '04021132',
      '22213211',
      '34444410',
      '31041311',
      NULL,
      '04314002',
      '21301331',
      '12444201',
      '41011111',
      '03212230',
      NULL,
      '14022030',
      '01210402',
      '11134202',
      '23323240',
      '10320203',
      '',
      '',
      NULL,
      NULL,
      '1434113',
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.920844,
      '10-23-2000',
      ' 5-15-1977',
      48.476101,
      NULL,
      NULL,
      10,
      11,
      3.688046,
      45.853170,
      19,
      NULL,
      NULL,
      22.407679,
      NULL,
      12,
      6,
      14,
      14.066292,
      17,
      1,
      7,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      63,
      128.946915,
      113,
      89.365053,
      ' 0- 2-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      4,
      12.208692,
      29.523734,
      55,
      30,
      8,
      NULL,
      NULL,
      1.378768,
      ' 5-27-1979',
      5,
      1.562999,
      11.717238,
      9,
      12,
      3.394271,
      NULL,
      3.045846,
      NULL,
      46,
      1,
      0.749124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      24.327394,
      33,
      ' 8- 5-1987',
      4,
      NULL,
      '10-27-1999',
      0,
      186,
      12.446567,
      95.849263,
      ' 7-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.579661,
      NULL,
      51.789219,
      0,
      2,
      0,
      2.108326,
      63.500323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      53.631873,
      1,
      69,
      3.288721,
      0.128887,
      1,
      1.129449,
      0.831535,
      NULL,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311936,
      62.990546,
      0.452063,
      1,
      2,
      17.303285,
      0.781195,
      NULL,
      59.148458,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1986',
      ' 3-11-1991',
      NULL,
      NULL,
      ' 7-28-1984',
      NULL,
      NULL,
      NULL);
commit;
end;
/


