set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20342131',
      '13000111',
      '12233133',
      '23342044',
      '34030221',
      '21330311',
      '40201440',
      NULL,
      '43102301',
      '12230323',
      '34024030',
      '22120323',
      '24020312',
      '00312042',
      '10013034',
      '24014202',
      NULL,
      '11003301',
      '22303244',
      NULL,
      '32443102',
      NULL,
      '00324244',
      '11402421',
      '43013432',
      NULL,
      '23414330',
      '44111301',
      '01034133',
      '41233412',
      NULL,
      '22402104',
      '12233014',
      '03422234',
      '03134031',
      '02120313',
      NULL,
      '32214230',
      NULL,
      '12310330',
      '43143134',
      NULL,
      '31434031',
      '34300344',
      NULL,
      '01',
      NULL,
      NULL,
      '4133331',
      NULL,
      34,
      1,
      NULL,
      NULL,
      NULL,
      ' 6-17-1996',
      NULL,
      31.132745,
      NULL,
      11,
      7.094657,
      12,
      14,
      58,
      9,
      8,
      1,
      22,
      6,
      2.941705,
      15.629042,
      NULL,
      9,
      4.964543,
      2,
      15.860270,
      7,
      NULL,
      6,
      NULL,
      8.854807,
      NULL,
      37.416391,
      NULL,
      2,
      90.629494,
      35.454277,
      159,
      ' 4-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      18.438031,
      16.684647,
      NULL,
      9.109212,
      5,
      ' 2-29-1997',
      NULL,
      1.621042,
      183,
      3,
      3.723027,
      54.889519,
      6.794165,
      1.286327,
      NULL,
      0.100055,
      NULL,
      176,
      ' 0-26-1999',
      35.579843,
      65.204417,
      106,
      109.729671,
      40.913198,
      61.631569,
      30.334928,
      105,
      85.588381,
      75.571064,
      20,
      70.484544,
      ' 9-27-1987',
      11.229241,
      13,
      19.564845,
      NULL,
      46.438365,
      54.146965,
      11.583637,
      ' 2-19-1976',
      2,
      1,
      ' 7- 4-1988',
      2,
      NULL,
      4,
      13.447574,
      1,
      NULL,
      1.090176,
      12,
      NULL,
      NULL,
      0.010961,
      1,
      3.093596,
      16,
      1.479048,
      NULL,
      0,
      0.526170,
      ' 3-25-1977',
      6,
      1.923920,
      0,
      ' 7-19-1989',
      55.004343,
      9.766807,
      '10- 5-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-1986',
      37,
      NULL,
      NULL,
      4.480270,
      NULL,
      46.836135,
      1.482486,
      '10-18-1981',
      9,
      2.833320,
      ' 0-15-1985',
      0.857022,
      NULL,
      ' 3- 4-1983',
      1,
      1,
      19,
      '10- 5-1998',
      31,
      23.951188,
      16.550038,
      ' 4- 3-1986',
      1.296948,
      21.847412,
      ' 9- 1-1983',
      NULL,
      14,
      5.973231,
      NULL,
      ' 9-28-1974',
      26,
      1,
      NULL,
      '11-14-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.888116);
commit;
end;
/


