set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3302',
      '30130020',
      NULL,
      NULL,
      NULL,
      '10111042',
      NULL,
      '04400404',
      '13240431',
      NULL,
      '44433232',
      NULL,
      NULL,
      '13124243',
      NULL,
      '33220202',
      '04023134',
      '41221214',
      '03442104',
      '33110413',
      '30041320',
      '40244131',
      '32203442',
      '10431323',
      '34343343',
      '22303212',
      '34031042',
      '13223333',
      '33330120',
      '21341414',
      '32434020',
      '01313331',
      '12210133',
      '43022231',
      '34220200',
      '13122410',
      '41020143',
      '40344443',
      '10140310',
      '43101121',
      '01121233',
      '30441440',
      '34310400',
      '33211043',
      NULL,
      NULL,
      '33',
      NULL,
      NULL,
      '1101011',
      1,
      87.660125,
      0,
      NULL,
      '421202',
      5.285646,
      ' 7-27-1991',
      ' 8- 0-1980',
      51,
      NULL,
      7,
      0.168992,
      2.550035,
      2.490264,
      51.126665,
      12.840948,
      15.684761,
      2.983206,
      7.864491,
      1.295830,
      NULL,
      10,
      NULL,
      NULL,
      1,
      NULL,
      26,
      3.126361,
      22,
      5.040052,
      NULL,
      11,
      1.386889,
      22,
      70,
      21,
      27,
      63,
      127,
      ' 5-13-1976',
      NULL,
      NULL,
      13,
      21.948980,
      2.060054,
      136.497942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.871006,
      41.555830,
      NULL,
      43,
      0.209217,
      1,
      ' 9- 6-1974',
      2,
      4.188454,
      173.257009,
      NULL,
      3.082352,
      108,
      3,
      3.081541,
      4,
      NULL,
      NULL,
      NULL,
      '11-13-1983',
      39.283812,
      NULL,
      54,
      40,
      20,
      NULL,
      17,
      66.763072,
      NULL,
      10.550503,
      NULL,
      32,
      ' 6- 2-1978',
      NULL,
      NULL,
      12.202835,
      10,
      NULL,
      26.821974,
      0.304332,
      '11-24-1991',
      8,
      14,
      ' 8-12-1980',
      11,
      15,
      2.599121,
      5,
      NULL,
      8.909385,
      1,
      3.936352,
      1.405094,
      28.131166,
      1,
      9,
      1,
      NULL,
      2.015723,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.515473,
      NULL,
      '11-21-2000',
      NULL,
      NULL,
      NULL,
      23,
      ' 8-11-1998',
      18,
      NULL,
      15.446815,
      12,
      '10-13-1993',
      NULL,
      NULL,
      NULL,
      0.805617,
      6.009989,
      ' 7- 3-1981',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.381170,
      NULL,
      13,
      2,
      9,
      ' 9-17-1994',
      2,
      281,
      ' 8-10-1983',
      1.196675,
      19.402201,
      20.368709,
      53.877090,
      ' 2-18-1984',
      62,
      0,
      70.677316,
      ' 7- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


