set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '2',
      '3',
      '3',
      '2',
      '2',
      NULL,
      '0',
      '3',
      NULL,
      '2',
      '2',
      '0',
      NULL,
      '0',
      '2',
      '4',
      '1',
      NULL,
      '2',
      '1',
      '1',
      NULL,
      NULL,
      '3',
      NULL,
      '3',
      NULL,
      '0',
      '0',
      '2',
      '',
      '',
      '1',
      NULL,
      '0',
      '1',
      '4',
      '4',
      '4',
      '2',
      NULL,
      '4',
      '2',
      '214',
      NULL,
      27.050354,
      8.682916,
      '0001013',
      1.311532,
      16.120711,
      1,
      NULL,
      '101020',
      0,
      ' 3- 6-1980',
      NULL,
      143.694364,
      83,
      6,
      12.995190,
      11,
      NULL,
      22.169546,
      13.534119,
      13.431460,
      5.865753,
      5.119020,
      4,
      NULL,
      2,
      20.623345,
      6.348844,
      2.343853,
      3,
      31,
      0.519291,
      16,
      NULL,
      30,
      10.997765,
      1,
      19.193457,
      160.767338,
      NULL,
      65,
      28.465819,
      75,
      '10-20-1993',
      11,
      2,
      6,
      10.615596,
      81.572873,
      170,
      ' 8-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      13,
      64,
      NULL,
      8.562312,
      1.813492,
      ' 6-16-1999',
      0.420686,
      1,
      48.907587,
      1,
      1.247625,
      13.322523,
      4,
      5,
      13.525524,
      NULL,
      NULL,
      NULL,
      ' 8-19-1976',
      23,
      17,
      NULL,
      36.039532,
      NULL,
      14.882669,
      41.804082,
      NULL,
      4,
      NULL,
      NULL,
      29.767420,
      ' 4-13-1974',
      10.316276,
      6.488330,
      1,
      22,
      32,
      14.135478,
      6.060486,
      ' 1-21-1987',
      7,
      NULL,
      '10- 7-1987',
      2.836683,
      5.095481,
      5.543464,
      6.042211,
      1.969553,
      NULL,
      0,
      3,
      NULL,
      15.104169,
      0.441436,
      0.041595,
      4,
      13.443912,
      7,
      NULL,
      1.400367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      ' 8- 1-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-1992',
      28.238928,
      ' 2-11-1987',
      5.270434,
      9.850432,
      '10-29-2000',
      88,
      81,
      '10-20-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      10.491496,
      ' 1- 7-1979',
      NULL,
      15.204146,
      6.448516,
      ' 3- 0-1989',
      NULL,
      160,
      ' 6-22-1985',
      2.398320,
      NULL,
      7,
      88.804280,
      ' 8-25-1996',
      NULL,
      0,
      148.582170,
      ' 7- 9-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


