set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9013377';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      '0',
      '4',
      '3',
      '0',
      '3',
      '4',
      '3',
      '3',
      '3',
      '3',
      '2',
      NULL,
      '0',
      '2',
      NULL,
      '0',
      '0',
      '3',
      '2',
      NULL,
      '3',
      '2',
      '',
      '3',
      '',
      '0',
      '2',
      NULL,
      NULL,
      '4',
      '',
      '',
      '4',
      '2',
      '0',
      '0',
      '1',
      '4',
      '1',
      '2',
      NULL,
      '2',
      '2',
      '231',
      '40312400',
      43,
      11,
      '1342321',
      0,
      NULL,
      1,
      0,
      '032433',
      3,
      ' 6-15-1985',
      ' 9-23-1977',
      3.203574,
      67.601275,
      NULL,
      2.209407,
      4.779371,
      8.843009,
      34.915239,
      NULL,
      11.874413,
      9,
      NULL,
      3.218664,
      NULL,
      15,
      8,
      16.258250,
      NULL,
      8,
      35.930701,
      10,
      9,
      6,
      39,
      8,
      0.734866,
      47.326648,
      122.620985,
      39.569124,
      83.175217,
      99,
      7.400575,
      ' 0- 2-1986',
      37,
      NULL,
      0.936250,
      NULL,
      NULL,
      128.360148,
      '11- 2-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.221747,
      19.360010,
      17,
      14,
      16,
      4,
      ' 3-25-1991',
      1,
      0,
      16.335978,
      0,
      0,
      44,
      1.383625,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      ' 6-21-1981',
      18,
      27.512712,
      40.294647,
      10,
      22.845527,
      NULL,
      NULL,
      NULL,
      7.274787,
      10.718323,
      19.912932,
      26.874118,
      ' 6- 6-1974',
      17.629929,
      16.643919,
      3.870012,
      25,
      41,
      2.377590,
      7,
      ' 3- 1-1986',
      8,
      6,
      ' 6-24-1998',
      3.626428,
      NULL,
      17,
      22.970761,
      NULL,
      5.757978,
      0.432971,
      8.005538,
      1.077319,
      NULL,
      0,
      1,
      12,
      NULL,
      0.602152,
      5.683336,
      0.633805,
      NULL,
      ' 8-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      '11- 2-2000',
      NULL,
      NULL,
      NULL,
      14.964587,
      ' 4-12-2003',
      3,
      ' 5-14-1979',
      0,
      2,
      ' 0- 2-1994',
      39,
      64,
      ' 6-29-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.600940,
      NULL,
      38,
      16,
      15,
      ' 7-12-1974',
      5,
      7,
      ' 4- 3-1997',
      6,
      71.257624,
      NULL,
      30.710379,
      ' 4-20-1991',
      13,
      1.813422,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


