set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0010',
      NULL,
      '04224002',
      '20411201',
      '23223123',
      '22130133',
      '34000440',
      '14220124',
      '44444023',
      '34231301',
      '04420221',
      '00140010',
      '22224434',
      '22340042',
      '02323334',
      '31223013',
      '43443001',
      NULL,
      '01404434',
      NULL,
      '44423031',
      '30301234',
      NULL,
      '30210412',
      '00213430',
      '40240403',
      '22032402',
      '04134141',
      '34444414',
      '02441401',
      '33114401',
      '42201344',
      '14102004',
      '41300401',
      '23042244',
      '40243004',
      NULL,
      '41413012',
      '14320122',
      '22210100',
      '22021400',
      NULL,
      '11201144',
      '20233112',
      '30202234',
      '420',
      '41',
      NULL,
      NULL,
      '4321034',
      NULL,
      NULL,
      2,
      NULL,
      '230014',
      1.308108,
      ' 5-12-1983',
      NULL,
      117,
      NULL,
      2,
      3.578986,
      NULL,
      8,
      39.810653,
      7,
      5.772023,
      4,
      20.568736,
      11.182745,
      6.786410,
      2,
      NULL,
      12,
      8.382685,
      NULL,
      7.103408,
      6,
      63.589363,
      5.979513,
      11,
      5.093321,
      1.479539,
      47.373993,
      81,
      71.566951,
      179.717660,
      152.587868,
      NULL,
      NULL,
      NULL,
      48,
      27,
      NULL,
      120.557658,
      NULL,
      ' 3- 5-2002',
      1.816877,
      7.598106,
      1,
      11.739326,
      1.312288,
      5.342071,
      1,
      14.020178,
      1.790243,
      1.551852,
      6.320879,
      0,
      0,
      NULL,
      1.515664,
      1.146136,
      12,
      1,
      0,
      10.012860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.249943,
      20,
      16,
      14.016921,
      4.177438,
      2.232426,
      ' 7-29-1997',
      0,
      0.065686,
      96.227796,
      1,
      0,
      26.952551,
      1,
      1.565126,
      26.559575,
      NULL,
      NULL,
      NULL,
      ' 0- 7-2000',
      55.360347,
      NULL,
      NULL,
      NULL,
      52.561643,
      NULL,
      29.310927,
      NULL,
      23.150756,
      46,
      4,
      30,
      '11-13-1983',
      NULL,
      6.073486,
      12.564150,
      5,
      87.052641,
      66,
      NULL,
      ' 0-23-1999',
      6,
      6,
      ' 1-14-1978',
      1,
      14,
      12.475374,
      13,
      22,
      NULL,
      0.293009,
      10.539348,
      0.688482,
      124,
      6.867676,
      5.061643,
      NULL,
      NULL,
      1.679770,
      0.894590,
      1.350393,
      1,
      '11-19-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      135,
      2.356564,
      ' 4-21-1989',
      NULL,
      NULL,
      NULL,
      35.654309,
      '10- 8-1999',
      3.895514,
      ' 7- 2-1978',
      8,
      5.149861,
      ' 3-23-1984',
      NULL,
      NULL,
      ' 9-28-1980',
      0,
      NULL,
      ' 6-26-1981',
      NULL,
      NULL,
      NULL,
      3,
      1,
      9,
      ' 3-21-1974',
      NULL,
      NULL,
      15,
      NULL,
      1,
      111,
      ' 7-11-1984',
      9,
      47,
      NULL,
      68.558614,
      ' 9-20-2002',
      30.523788,
      0,
      111.464401,
      '11-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


