set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923985';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2330',
      '20002443',
      '21013321',
      '40003313',
      '24102403',
      '01144430',
      '04111000',
      NULL,
      '41312404',
      '14211331',
      NULL,
      NULL,
      '42132033',
      '42000111',
      '32341123',
      '42131013',
      '03003214',
      '03211243',
      '41141412',
      NULL,
      '43142431',
      '22033423',
      '21404100',
      '31310023',
      '02444310',
      NULL,
      '31002412',
      NULL,
      NULL,
      NULL,
      '42012432',
      '33024211',
      '04102440',
      '20122232',
      '43410210',
      '44210312',
      '33222003',
      '22432402',
      '22240121',
      '04422202',
      '14214210',
      '14222431',
      '13000124',
      '10303233',
      '20423002',
      '331',
      '02',
      14.820116,
      15,
      '1333011',
      0,
      NULL,
      0,
      NULL,
      '142333',
      0.192025,
      NULL,
      ' 8-18-1987',
      96,
      12,
      38,
      14,
      11.701565,
      NULL,
      40.466167,
      17,
      10,
      15.478875,
      6.594248,
      NULL,
      NULL,
      13.957126,
      15.729450,
      16.311770,
      29.222339,
      4,
      12,
      NULL,
      5,
      19,
      64.891348,
      0.805404,
      1.085467,
      18.239510,
      87,
      NULL,
      106.527502,
      27,
      25,
      ' 0-29-1975',
      NULL,
      47.575505,
      11.656650,
      3,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      97,
      19.272137,
      5,
      14,
      10.008307,
      4,
      ' 8-26-1987',
      NULL,
      NULL,
      55,
      1.194624,
      1,
      58.657101,
      1,
      1.300830,
      39,
      NULL,
      NULL,
      NULL,
      ' 9-27-1998',
      92.378299,
      76.478155,
      57,
      64,
      28,
      76.333752,
      52,
      4.106891,
      14.054050,
      NULL,
      18.485413,
      41,
      ' 4-23-1994',
      1.957426,
      19.150655,
      1.984312,
      11,
      60,
      43,
      7,
      NULL,
      27,
      11,
      ' 2-14-1998',
      9,
      6,
      9.414860,
      1.386665,
      12,
      2,
      0.915741,
      1,
      0.080253,
      2.430693,
      0,
      3.217566,
      NULL,
      18,
      2.115791,
      0.509050,
      3.487485,
      0,
      ' 2- 7-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.765088,
      '11- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-2000',
      NULL,
      ' 2-24-2001',
      NULL,
      2.226668,
      NULL,
      10,
      66.856981,
      ' 6-19-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      ' 9-10-1991',
      43.168907,
      24.808841,
      NULL,
      ' 2-21-1986',
      1.387833,
      NULL,
      ' 1-12-1987',
      14,
      NULL,
      NULL,
      15,
      NULL,
      69.510875,
      NULL,
      43,
      '11-17-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


