set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8020079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4441',
      '40323421',
      '24333323',
      '01121020',
      '02300200',
      '42213410',
      '23224023',
      NULL,
      '12210122',
      '22313234',
      '31040122',
      '00101013',
      '02344342',
      '44423324',
      '42132342',
      '41231224',
      '31041412',
      '02430010',
      '31102340',
      '34214043',
      '40233320',
      '22034324',
      NULL,
      NULL,
      '33313321',
      '43340020',
      '23023012',
      '02100113',
      '02203030',
      '12340402',
      '13030433',
      '44032312',
      '44304221',
      '11123434',
      '20041100',
      '13311320',
      '34101014',
      '22204144',
      NULL,
      '31313114',
      '11312302',
      '31313232',
      NULL,
      '23134043',
      '42033411',
      '',
      '',
      NULL,
      NULL,
      '2112212',
      1.660918,
      0.495317,
      1,
      NULL,
      '322222',
      NULL,
      ' 3-23-1981',
      ' 2-23-1995',
      38,
      NULL,
      42.412823,
      15.053869,
      9,
      NULL,
      81,
      8,
      13,
      19,
      NULL,
      1.693546,
      24,
      0.905323,
      NULL,
      NULL,
      2.094232,
      8.013683,
      42,
      29.701537,
      34,
      20,
      NULL,
      9,
      NULL,
      NULL,
      114,
      59,
      12,
      NULL,
      76.527206,
      ' 5-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889735,
      0.099626,
      0,
      0.849462,
      1.075765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      79.597395,
      28.509153,
      100.705796,
      40,
      NULL,
      0,
      96.475681,
      NULL,
      NULL,
      59.524052,
      83.793913,
      ' 4-11-1999',
      23,
      8,
      24.400496,
      8,
      NULL,
      NULL,
      NULL,
      '11-19-1989',
      12.077025,
      8.195371,
      ' 8-27-1996',
      1,
      4.293721,
      11,
      5.210446,
      14.163419,
      1,
      NULL,
      2,
      NULL,
      24.182989,
      0,
      4.728247,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-19-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      20,
      17.344102,
      ' 8-29-1998',
      NULL,
      NULL,
      ' 5-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.800712,
      NULL,
      NULL,
      91,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.799985,
      NULL,
      1.884879,
      NULL,
      0.754102,
      1.339866,
      0.738495,
      0.330554,
      NULL,
      ' 2-16-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-2000',
      NULL);
commit;
end;
/


