set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315469';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23040014',
      '11230104',
      NULL,
      '11121111',
      '01012400',
      '32214142',
      '43230401',
      '10444412',
      '34421401',
      '12030134',
      '11441122',
      '42334102',
      NULL,
      '22214341',
      '42040431',
      '40141341',
      '13104124',
      '03232120',
      NULL,
      '00011324',
      '13231114',
      '14430402',
      '21130022',
      '03400231',
      '31112001',
      '13430242',
      '13224302',
      NULL,
      '00321030',
      '32010012',
      '00303102',
      '30243041',
      '21244434',
      '34040114',
      '32413230',
      '04101203',
      '21112002',
      '43111410',
      NULL,
      '30024303',
      NULL,
      '43243410',
      '34323003',
      '33030433',
      '',
      '',
      NULL,
      NULL,
      '4000141',
      1,
      0,
      NULL,
      NULL,
      '213433',
      NULL,
      '11-18-1987',
      '11-25-1984',
      60.057455,
      NULL,
      NULL,
      NULL,
      4,
      18.554083,
      NULL,
      10,
      3,
      11.479126,
      NULL,
      14,
      NULL,
      14,
      16,
      NULL,
      12.418423,
      4,
      NULL,
      7,
      37,
      NULL,
      1,
      4.039641,
      NULL,
      102,
      87,
      30,
      60.527602,
      93.457708,
      91.047503,
      ' 2- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      14.906538,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.452804,
      1.505232,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-14-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-1999',
      NULL,
      7.621255,
      64,
      88.858709,
      81.085425,
      NULL,
      41,
      84,
      84.978230,
      88.438101,
      75.459213,
      39,
      '10-29-1986',
      4.037225,
      4,
      NULL,
      29,
      28,
      NULL,
      NULL,
      ' 2-18-1993',
      6.150607,
      10,
      ' 7- 3-1989',
      8.352249,
      3,
      NULL,
      NULL,
      18,
      2,
      NULL,
      3.787855,
      NULL,
      34,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.568183,
      NULL,
      '10- 1-2003',
      0.932708,
      63,
      ' 9-24-1991',
      NULL,
      4.596329,
      7,
      12.647273,
      ' 5- 8-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      131.537903,
      17,
      NULL,
      89,
      30,
      5,
      NULL,
      NULL,
      3,
      52.701142,
      0.207381,
      NULL,
      77,
      NULL,
      NULL,
      NULL,
      1.720506,
      7,
      55,
      8.186305,
      8.855583,
      199.468062,
      25,
      14,
      NULL,
      0.083001,
      42.515967,
      NULL,
      0,
      1.183966,
      0,
      2.185676,
      0,
      24,
      28,
      NULL,
      NULL,
      NULL,
      36,
      1,
      0.788737,
      NULL,
      1.420772,
      2.709524,
      1,
      3,
      0.796747,
      18.247860,
      0.999077,
      NULL,
      1,
      1.315897,
      44.003312,
      3.048705,
      0,
      4.180406,
      25.932203,
      52,
      NULL,
      NULL,
      10.913456,
      1,
      0.730450,
      2.385551,
      2.606561,
      4,
      1.868552,
      1.937935,
      57.837251,
      ' 9- 2-2002',
      ' 1-23-1984',
      NULL,
      '10- 0-1985',
      NULL,
      NULL,
      ' 3- 7-1976',
      NULL);
commit;
end;
/


