set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9921354';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      '3',
      NULL,
      NULL,
      '3',
      NULL,
      '4',
      NULL,
      '3',
      '4',
      NULL,
      '4',
      NULL,
      '4',
      NULL,
      '3',
      NULL,
      '2',
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '',
      '2',
      '2',
      '1',
      '3',
      NULL,
      '',
      '',
      NULL,
      '3',
      '3',
      '1',
      '2',
      '3',
      '3',
      '3',
      '1',
      '0',
      NULL,
      '304',
      '11230400',
      12,
      68,
      '2141034',
      3.890136,
      NULL,
      0,
      0,
      '222203',
      4,
      ' 7-25-1980',
      '11-16-1975',
      7,
      159,
      NULL,
      12.687639,
      24,
      NULL,
      32,
      NULL,
      10.314425,
      2,
      NULL,
      NULL,
      10.388108,
      7,
      6.222744,
      NULL,
      1.428373,
      9.079604,
      66.813977,
      23.570535,
      26,
      13,
      57.062134,
      9.702771,
      1.357315,
      68,
      162,
      1,
      NULL,
      92,
      138,
      NULL,
      NULL,
      NULL,
      NULL,
      23.396378,
      51,
      74.785322,
      ' 8- 6-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      11,
      6,
      3.545023,
      NULL,
      1,
      1.888573,
      161.353494,
      NULL,
      0,
      120.810763,
      1,
      NULL,
      34.545703,
      NULL,
      NULL,
      NULL,
      ' 7-27-1987',
      2,
      2.192942,
      NULL,
      58,
      NULL,
      10,
      19.401233,
      52.605855,
      54,
      42.242809,
      16.220615,
      44,
      ' 1-25-1979',
      14.487179,
      15.795381,
      1.726012,
      35,
      41,
      7,
      NULL,
      '11-15-1974',
      4,
      6,
      ' 0- 6-1982',
      3,
      2,
      6.894059,
      6.287435,
      NULL,
      8,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      13.528529,
      14,
      2,
      NULL,
      1.906169,
      1.087344,
      ' 0- 6-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      199.434653,
      7,
      ' 4- 9-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-24-2002',
      NULL,
      '11- 5-1998',
      5.169147,
      13,
      NULL,
      7,
      NULL,
      '10-26-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.456748,
      ' 1-25-1991',
      55.985088,
      0,
      1.710497,
      ' 8-25-1978',
      1,
      NULL,
      ' 7-16-1999',
      19,
      45.312390,
      NULL,
      42,
      ' 1- 1-1997',
      38,
      1,
      NULL,
      ' 7-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


